/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an individual managed node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<Instant> CAPTURE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CaptureTime").getter(getter(Node::captureTime)).setter(setter(Builder::captureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Node::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<NodeOwnerInfo> OWNER_FIELD = SdkField.<NodeOwnerInfo> builder(MarshallingType.SDK_POJO)
            .memberName("Owner").getter(getter(Node::owner)).setter(setter(Builder::owner)).constructor(NodeOwnerInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Node::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<NodeType> NODE_TYPE_FIELD = SdkField.<NodeType> builder(MarshallingType.SDK_POJO)
            .memberName("NodeType").getter(getter(Node::nodeType)).setter(setter(Builder::nodeType))
            .constructor(NodeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_TIME_FIELD, ID_FIELD,
            OWNER_FIELD, REGION_FIELD, NODE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant captureTime;

    private final String id;

    private final NodeOwnerInfo owner;

    private final String region;

    private final NodeType nodeType;

    private Node(BuilderImpl builder) {
        this.captureTime = builder.captureTime;
        this.id = builder.id;
        this.owner = builder.owner;
        this.region = builder.region;
        this.nodeType = builder.nodeType;
    }

    /**
     * <p>
     * The UTC timestamp for when the managed node data was last captured.
     * </p>
     * 
     * @return The UTC timestamp for when the managed node data was last captured.
     */
    public final Instant captureTime() {
        return captureTime;
    }

    /**
     * <p>
     * The ID of the managed node.
     * </p>
     * 
     * @return The ID of the managed node.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Information about the ownership of the managed node.
     * </p>
     * 
     * @return Information about the ownership of the managed node.
     */
    public final NodeOwnerInfo owner() {
        return owner;
    }

    /**
     * <p>
     * The Amazon Web Services Region that a managed node was created in or assigned to.
     * </p>
     * 
     * @return The Amazon Web Services Region that a managed node was created in or assigned to.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Information about the type of node.
     * </p>
     * 
     * @return Information about the type of node.
     */
    public final NodeType nodeType() {
        return nodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(captureTime(), other.captureTime()) && Objects.equals(id(), other.id())
                && Objects.equals(owner(), other.owner()) && Objects.equals(region(), other.region())
                && Objects.equals(nodeType(), other.nodeType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("CaptureTime", captureTime()).add("Id", id()).add("Owner", owner())
                .add("Region", region()).add("NodeType", nodeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptureTime":
            return Optional.ofNullable(clazz.cast(captureTime()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CaptureTime", CAPTURE_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The UTC timestamp for when the managed node data was last captured.
         * </p>
         * 
         * @param captureTime
         *        The UTC timestamp for when the managed node data was last captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureTime(Instant captureTime);

        /**
         * <p>
         * The ID of the managed node.
         * </p>
         * 
         * @param id
         *        The ID of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Information about the ownership of the managed node.
         * </p>
         * 
         * @param owner
         *        Information about the ownership of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(NodeOwnerInfo owner);

        /**
         * <p>
         * Information about the ownership of the managed node.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeOwnerInfo.Builder} avoiding the need
         * to create one manually via {@link NodeOwnerInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeOwnerInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #owner(NodeOwnerInfo)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link NodeOwnerInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(NodeOwnerInfo)
         */
        default Builder owner(Consumer<NodeOwnerInfo.Builder> owner) {
            return owner(NodeOwnerInfo.builder().applyMutation(owner).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region that a managed node was created in or assigned to.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region that a managed node was created in or assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Information about the type of node.
         * </p>
         * 
         * @param nodeType
         *        Information about the type of node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(NodeType nodeType);

        /**
         * <p>
         * Information about the type of node.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeType.Builder} avoiding the need to
         * create one manually via {@link NodeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeType.Builder#build()} is called immediately and its result is
         * passed to {@link #nodeType(NodeType)}.
         * 
         * @param nodeType
         *        a consumer that will call methods on {@link NodeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeType(NodeType)
         */
        default Builder nodeType(Consumer<NodeType.Builder> nodeType) {
            return nodeType(NodeType.builder().applyMutation(nodeType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant captureTime;

        private String id;

        private NodeOwnerInfo owner;

        private String region;

        private NodeType nodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            captureTime(model.captureTime);
            id(model.id);
            owner(model.owner);
            region(model.region);
            nodeType(model.nodeType);
        }

        public final Instant getCaptureTime() {
            return captureTime;
        }

        public final void setCaptureTime(Instant captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(Instant captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final NodeOwnerInfo.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(NodeOwnerInfo.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(NodeOwnerInfo owner) {
            this.owner = owner;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final NodeType.Builder getNodeType() {
            return nodeType != null ? nodeType.toBuilder() : null;
        }

        public final void setNodeType(NodeType.BuilderImpl nodeType) {
            this.nodeType = nodeType != null ? nodeType.build() : null;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
