/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;

public class DescribePatchBaselinesIterable
implements SdkIterable<DescribePatchBaselinesResponse> {
    private final SsmClient client;
    private final DescribePatchBaselinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePatchBaselinesIterable(SsmClient client, DescribePatchBaselinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribePatchBaselinesResponseFetcher();
    }

    public Iterator<DescribePatchBaselinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PatchBaselineIdentity> baselineIdentities() {
        Function<DescribePatchBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.baselineIdentities() != null) {
                return response.baselineIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribePatchBaselinesResponseFetcher
    implements SyncPageFetcher<DescribePatchBaselinesResponse> {
        private DescribePatchBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePatchBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePatchBaselinesResponse nextPage(DescribePatchBaselinesResponse previousPage) {
            if (previousPage == null) {
                return DescribePatchBaselinesIterable.this.client.describePatchBaselines(DescribePatchBaselinesIterable.this.firstRequest);
            }
            return DescribePatchBaselinesIterable.this.client.describePatchBaselines((DescribePatchBaselinesRequest)((Object)DescribePatchBaselinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

