/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.PatchOperationType;
import software.amazon.awssdk.services.ssm.model.RebootOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePatchState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstancePatchState> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstancePatchState.getter(InstancePatchState::instanceId)).setter(InstancePatchState.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchGroup").getter(InstancePatchState.getter(InstancePatchState::patchGroup)).setter(InstancePatchState.setter(Builder::patchGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()}).build();
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaselineId").getter(InstancePatchState.getter(InstancePatchState::baselineId)).setter(InstancePatchState.setter(Builder::baselineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(InstancePatchState.getter(InstancePatchState::snapshotId)).setter(InstancePatchState.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> INSTALL_OVERRIDE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstallOverrideList").getter(InstancePatchState.getter(InstancePatchState::installOverrideList)).setter(InstancePatchState.setter(Builder::installOverrideList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallOverrideList").build()}).build();
    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerInformation").getter(InstancePatchState.getter(InstancePatchState::ownerInformation)).setter(InstancePatchState.setter(Builder::ownerInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()}).build();
    private static final SdkField<Integer> INSTALLED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstalledCount").getter(InstancePatchState.getter(InstancePatchState::installedCount)).setter(InstancePatchState.setter(Builder::installedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledCount").build()}).build();
    private static final SdkField<Integer> INSTALLED_OTHER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstalledOtherCount").getter(InstancePatchState.getter(InstancePatchState::installedOtherCount)).setter(InstancePatchState.setter(Builder::installedOtherCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledOtherCount").build()}).build();
    private static final SdkField<Integer> INSTALLED_PENDING_REBOOT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstalledPendingRebootCount").getter(InstancePatchState.getter(InstancePatchState::installedPendingRebootCount)).setter(InstancePatchState.setter(Builder::installedPendingRebootCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledPendingRebootCount").build()}).build();
    private static final SdkField<Integer> INSTALLED_REJECTED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstalledRejectedCount").getter(InstancePatchState.getter(InstancePatchState::installedRejectedCount)).setter(InstancePatchState.setter(Builder::installedRejectedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledRejectedCount").build()}).build();
    private static final SdkField<Integer> MISSING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MissingCount").getter(InstancePatchState.getter(InstancePatchState::missingCount)).setter(InstancePatchState.setter(Builder::missingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingCount").build()}).build();
    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedCount").getter(InstancePatchState.getter(InstancePatchState::failedCount)).setter(InstancePatchState.setter(Builder::failedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()}).build();
    private static final SdkField<Integer> UNREPORTED_NOT_APPLICABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnreportedNotApplicableCount").getter(InstancePatchState.getter(InstancePatchState::unreportedNotApplicableCount)).setter(InstancePatchState.setter(Builder::unreportedNotApplicableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnreportedNotApplicableCount").build()}).build();
    private static final SdkField<Integer> NOT_APPLICABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NotApplicableCount").getter(InstancePatchState.getter(InstancePatchState::notApplicableCount)).setter(InstancePatchState.setter(Builder::notApplicableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicableCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_SECURITY_UPDATE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableSecurityUpdateCount").getter(InstancePatchState.getter(InstancePatchState::availableSecurityUpdateCount)).setter(InstancePatchState.setter(Builder::availableSecurityUpdateCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSecurityUpdateCount").build()}).build();
    private static final SdkField<Instant> OPERATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OperationStartTime").getter(InstancePatchState.getter(InstancePatchState::operationStartTime)).setter(InstancePatchState.setter(Builder::operationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStartTime").build()}).build();
    private static final SdkField<Instant> OPERATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OperationEndTime").getter(InstancePatchState.getter(InstancePatchState::operationEndTime)).setter(InstancePatchState.setter(Builder::operationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationEndTime").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(InstancePatchState.getter(InstancePatchState::operationAsString)).setter(InstancePatchState.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<Instant> LAST_NO_REBOOT_INSTALL_OPERATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastNoRebootInstallOperationTime").getter(InstancePatchState.getter(InstancePatchState::lastNoRebootInstallOperationTime)).setter(InstancePatchState.setter(Builder::lastNoRebootInstallOperationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastNoRebootInstallOperationTime").build()}).build();
    private static final SdkField<String> REBOOT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RebootOption").getter(InstancePatchState.getter(InstancePatchState::rebootOptionAsString)).setter(InstancePatchState.setter(Builder::rebootOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebootOption").build()}).build();
    private static final SdkField<Integer> CRITICAL_NON_COMPLIANT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CriticalNonCompliantCount").getter(InstancePatchState.getter(InstancePatchState::criticalNonCompliantCount)).setter(InstancePatchState.setter(Builder::criticalNonCompliantCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CriticalNonCompliantCount").build()}).build();
    private static final SdkField<Integer> SECURITY_NON_COMPLIANT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecurityNonCompliantCount").getter(InstancePatchState.getter(InstancePatchState::securityNonCompliantCount)).setter(InstancePatchState.setter(Builder::securityNonCompliantCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityNonCompliantCount").build()}).build();
    private static final SdkField<Integer> OTHER_NON_COMPLIANT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OtherNonCompliantCount").getter(InstancePatchState.getter(InstancePatchState::otherNonCompliantCount)).setter(InstancePatchState.setter(Builder::otherNonCompliantCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherNonCompliantCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PATCH_GROUP_FIELD, BASELINE_ID_FIELD, SNAPSHOT_ID_FIELD, INSTALL_OVERRIDE_LIST_FIELD, OWNER_INFORMATION_FIELD, INSTALLED_COUNT_FIELD, INSTALLED_OTHER_COUNT_FIELD, INSTALLED_PENDING_REBOOT_COUNT_FIELD, INSTALLED_REJECTED_COUNT_FIELD, MISSING_COUNT_FIELD, FAILED_COUNT_FIELD, UNREPORTED_NOT_APPLICABLE_COUNT_FIELD, NOT_APPLICABLE_COUNT_FIELD, AVAILABLE_SECURITY_UPDATE_COUNT_FIELD, OPERATION_START_TIME_FIELD, OPERATION_END_TIME_FIELD, OPERATION_FIELD, LAST_NO_REBOOT_INSTALL_OPERATION_TIME_FIELD, REBOOT_OPTION_FIELD, CRITICAL_NON_COMPLIANT_COUNT_FIELD, SECURITY_NON_COMPLIANT_COUNT_FIELD, OTHER_NON_COMPLIANT_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstancePatchState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String patchGroup;
    private final String baselineId;
    private final String snapshotId;
    private final String installOverrideList;
    private final String ownerInformation;
    private final Integer installedCount;
    private final Integer installedOtherCount;
    private final Integer installedPendingRebootCount;
    private final Integer installedRejectedCount;
    private final Integer missingCount;
    private final Integer failedCount;
    private final Integer unreportedNotApplicableCount;
    private final Integer notApplicableCount;
    private final Integer availableSecurityUpdateCount;
    private final Instant operationStartTime;
    private final Instant operationEndTime;
    private final String operation;
    private final Instant lastNoRebootInstallOperationTime;
    private final String rebootOption;
    private final Integer criticalNonCompliantCount;
    private final Integer securityNonCompliantCount;
    private final Integer otherNonCompliantCount;

    private InstancePatchState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.patchGroup = builder.patchGroup;
        this.baselineId = builder.baselineId;
        this.snapshotId = builder.snapshotId;
        this.installOverrideList = builder.installOverrideList;
        this.ownerInformation = builder.ownerInformation;
        this.installedCount = builder.installedCount;
        this.installedOtherCount = builder.installedOtherCount;
        this.installedPendingRebootCount = builder.installedPendingRebootCount;
        this.installedRejectedCount = builder.installedRejectedCount;
        this.missingCount = builder.missingCount;
        this.failedCount = builder.failedCount;
        this.unreportedNotApplicableCount = builder.unreportedNotApplicableCount;
        this.notApplicableCount = builder.notApplicableCount;
        this.availableSecurityUpdateCount = builder.availableSecurityUpdateCount;
        this.operationStartTime = builder.operationStartTime;
        this.operationEndTime = builder.operationEndTime;
        this.operation = builder.operation;
        this.lastNoRebootInstallOperationTime = builder.lastNoRebootInstallOperationTime;
        this.rebootOption = builder.rebootOption;
        this.criticalNonCompliantCount = builder.criticalNonCompliantCount;
        this.securityNonCompliantCount = builder.securityNonCompliantCount;
        this.otherNonCompliantCount = builder.otherNonCompliantCount;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String patchGroup() {
        return this.patchGroup;
    }

    public final String baselineId() {
        return this.baselineId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String installOverrideList() {
        return this.installOverrideList;
    }

    public final String ownerInformation() {
        return this.ownerInformation;
    }

    public final Integer installedCount() {
        return this.installedCount;
    }

    public final Integer installedOtherCount() {
        return this.installedOtherCount;
    }

    public final Integer installedPendingRebootCount() {
        return this.installedPendingRebootCount;
    }

    public final Integer installedRejectedCount() {
        return this.installedRejectedCount;
    }

    public final Integer missingCount() {
        return this.missingCount;
    }

    public final Integer failedCount() {
        return this.failedCount;
    }

    public final Integer unreportedNotApplicableCount() {
        return this.unreportedNotApplicableCount;
    }

    public final Integer notApplicableCount() {
        return this.notApplicableCount;
    }

    public final Integer availableSecurityUpdateCount() {
        return this.availableSecurityUpdateCount;
    }

    public final Instant operationStartTime() {
        return this.operationStartTime;
    }

    public final Instant operationEndTime() {
        return this.operationEndTime;
    }

    public final PatchOperationType operation() {
        return PatchOperationType.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final Instant lastNoRebootInstallOperationTime() {
        return this.lastNoRebootInstallOperationTime;
    }

    public final RebootOption rebootOption() {
        return RebootOption.fromValue(this.rebootOption);
    }

    public final String rebootOptionAsString() {
        return this.rebootOption;
    }

    public final Integer criticalNonCompliantCount() {
        return this.criticalNonCompliantCount;
    }

    public final Integer securityNonCompliantCount() {
        return this.securityNonCompliantCount;
    }

    public final Integer otherNonCompliantCount() {
        return this.otherNonCompliantCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.installOverrideList());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedOtherCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedPendingRebootCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedRejectedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unreportedNotApplicableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableSecurityUpdateCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastNoRebootInstallOperationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.rebootOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticalNonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityNonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherNonCompliantCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchState)) {
            return false;
        }
        InstancePatchState other = (InstancePatchState)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.patchGroup(), other.patchGroup()) && Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.installOverrideList(), other.installOverrideList()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.installedCount(), other.installedCount()) && Objects.equals(this.installedOtherCount(), other.installedOtherCount()) && Objects.equals(this.installedPendingRebootCount(), other.installedPendingRebootCount()) && Objects.equals(this.installedRejectedCount(), other.installedRejectedCount()) && Objects.equals(this.missingCount(), other.missingCount()) && Objects.equals(this.failedCount(), other.failedCount()) && Objects.equals(this.unreportedNotApplicableCount(), other.unreportedNotApplicableCount()) && Objects.equals(this.notApplicableCount(), other.notApplicableCount()) && Objects.equals(this.availableSecurityUpdateCount(), other.availableSecurityUpdateCount()) && Objects.equals(this.operationStartTime(), other.operationStartTime()) && Objects.equals(this.operationEndTime(), other.operationEndTime()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.lastNoRebootInstallOperationTime(), other.lastNoRebootInstallOperationTime()) && Objects.equals(this.rebootOptionAsString(), other.rebootOptionAsString()) && Objects.equals(this.criticalNonCompliantCount(), other.criticalNonCompliantCount()) && Objects.equals(this.securityNonCompliantCount(), other.securityNonCompliantCount()) && Objects.equals(this.otherNonCompliantCount(), other.otherNonCompliantCount());
    }

    public final String toString() {
        return ToString.builder((String)"InstancePatchState").add("InstanceId", (Object)this.instanceId()).add("PatchGroup", (Object)this.patchGroup()).add("BaselineId", (Object)this.baselineId()).add("SnapshotId", (Object)this.snapshotId()).add("InstallOverrideList", (Object)this.installOverrideList()).add("OwnerInformation", (Object)(this.ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("InstalledCount", (Object)this.installedCount()).add("InstalledOtherCount", (Object)this.installedOtherCount()).add("InstalledPendingRebootCount", (Object)this.installedPendingRebootCount()).add("InstalledRejectedCount", (Object)this.installedRejectedCount()).add("MissingCount", (Object)this.missingCount()).add("FailedCount", (Object)this.failedCount()).add("UnreportedNotApplicableCount", (Object)this.unreportedNotApplicableCount()).add("NotApplicableCount", (Object)this.notApplicableCount()).add("AvailableSecurityUpdateCount", (Object)this.availableSecurityUpdateCount()).add("OperationStartTime", (Object)this.operationStartTime()).add("OperationEndTime", (Object)this.operationEndTime()).add("Operation", (Object)this.operationAsString()).add("LastNoRebootInstallOperationTime", (Object)this.lastNoRebootInstallOperationTime()).add("RebootOption", (Object)this.rebootOptionAsString()).add("CriticalNonCompliantCount", (Object)this.criticalNonCompliantCount()).add("SecurityNonCompliantCount", (Object)this.securityNonCompliantCount()).add("OtherNonCompliantCount", (Object)this.otherNonCompliantCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PatchGroup": {
                return Optional.ofNullable(clazz.cast(this.patchGroup()));
            }
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "InstallOverrideList": {
                return Optional.ofNullable(clazz.cast(this.installOverrideList()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "InstalledCount": {
                return Optional.ofNullable(clazz.cast(this.installedCount()));
            }
            case "InstalledOtherCount": {
                return Optional.ofNullable(clazz.cast(this.installedOtherCount()));
            }
            case "InstalledPendingRebootCount": {
                return Optional.ofNullable(clazz.cast(this.installedPendingRebootCount()));
            }
            case "InstalledRejectedCount": {
                return Optional.ofNullable(clazz.cast(this.installedRejectedCount()));
            }
            case "MissingCount": {
                return Optional.ofNullable(clazz.cast(this.missingCount()));
            }
            case "FailedCount": {
                return Optional.ofNullable(clazz.cast(this.failedCount()));
            }
            case "UnreportedNotApplicableCount": {
                return Optional.ofNullable(clazz.cast(this.unreportedNotApplicableCount()));
            }
            case "NotApplicableCount": {
                return Optional.ofNullable(clazz.cast(this.notApplicableCount()));
            }
            case "AvailableSecurityUpdateCount": {
                return Optional.ofNullable(clazz.cast(this.availableSecurityUpdateCount()));
            }
            case "OperationStartTime": {
                return Optional.ofNullable(clazz.cast(this.operationStartTime()));
            }
            case "OperationEndTime": {
                return Optional.ofNullable(clazz.cast(this.operationEndTime()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "LastNoRebootInstallOperationTime": {
                return Optional.ofNullable(clazz.cast(this.lastNoRebootInstallOperationTime()));
            }
            case "RebootOption": {
                return Optional.ofNullable(clazz.cast(this.rebootOptionAsString()));
            }
            case "CriticalNonCompliantCount": {
                return Optional.ofNullable(clazz.cast(this.criticalNonCompliantCount()));
            }
            case "SecurityNonCompliantCount": {
                return Optional.ofNullable(clazz.cast(this.securityNonCompliantCount()));
            }
            case "OtherNonCompliantCount": {
                return Optional.ofNullable(clazz.cast(this.otherNonCompliantCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PatchGroup", PATCH_GROUP_FIELD);
        map.put("BaselineId", BASELINE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("InstallOverrideList", INSTALL_OVERRIDE_LIST_FIELD);
        map.put("OwnerInformation", OWNER_INFORMATION_FIELD);
        map.put("InstalledCount", INSTALLED_COUNT_FIELD);
        map.put("InstalledOtherCount", INSTALLED_OTHER_COUNT_FIELD);
        map.put("InstalledPendingRebootCount", INSTALLED_PENDING_REBOOT_COUNT_FIELD);
        map.put("InstalledRejectedCount", INSTALLED_REJECTED_COUNT_FIELD);
        map.put("MissingCount", MISSING_COUNT_FIELD);
        map.put("FailedCount", FAILED_COUNT_FIELD);
        map.put("UnreportedNotApplicableCount", UNREPORTED_NOT_APPLICABLE_COUNT_FIELD);
        map.put("NotApplicableCount", NOT_APPLICABLE_COUNT_FIELD);
        map.put("AvailableSecurityUpdateCount", AVAILABLE_SECURITY_UPDATE_COUNT_FIELD);
        map.put("OperationStartTime", OPERATION_START_TIME_FIELD);
        map.put("OperationEndTime", OPERATION_END_TIME_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("LastNoRebootInstallOperationTime", LAST_NO_REBOOT_INSTALL_OPERATION_TIME_FIELD);
        map.put("RebootOption", REBOOT_OPTION_FIELD);
        map.put("CriticalNonCompliantCount", CRITICAL_NON_COMPLIANT_COUNT_FIELD);
        map.put("SecurityNonCompliantCount", SECURITY_NON_COMPLIANT_COUNT_FIELD);
        map.put("OtherNonCompliantCount", OTHER_NON_COMPLIANT_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancePatchState, T> g) {
        return obj -> g.apply((InstancePatchState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String patchGroup;
        private String baselineId;
        private String snapshotId;
        private String installOverrideList;
        private String ownerInformation;
        private Integer installedCount;
        private Integer installedOtherCount;
        private Integer installedPendingRebootCount;
        private Integer installedRejectedCount;
        private Integer missingCount;
        private Integer failedCount;
        private Integer unreportedNotApplicableCount;
        private Integer notApplicableCount;
        private Integer availableSecurityUpdateCount;
        private Instant operationStartTime;
        private Instant operationEndTime;
        private String operation;
        private Instant lastNoRebootInstallOperationTime;
        private String rebootOption;
        private Integer criticalNonCompliantCount;
        private Integer securityNonCompliantCount;
        private Integer otherNonCompliantCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchState model) {
            this.instanceId(model.instanceId);
            this.patchGroup(model.patchGroup);
            this.baselineId(model.baselineId);
            this.snapshotId(model.snapshotId);
            this.installOverrideList(model.installOverrideList);
            this.ownerInformation(model.ownerInformation);
            this.installedCount(model.installedCount);
            this.installedOtherCount(model.installedOtherCount);
            this.installedPendingRebootCount(model.installedPendingRebootCount);
            this.installedRejectedCount(model.installedRejectedCount);
            this.missingCount(model.missingCount);
            this.failedCount(model.failedCount);
            this.unreportedNotApplicableCount(model.unreportedNotApplicableCount);
            this.notApplicableCount(model.notApplicableCount);
            this.availableSecurityUpdateCount(model.availableSecurityUpdateCount);
            this.operationStartTime(model.operationStartTime);
            this.operationEndTime(model.operationEndTime);
            this.operation(model.operation);
            this.lastNoRebootInstallOperationTime(model.lastNoRebootInstallOperationTime);
            this.rebootOption(model.rebootOption);
            this.criticalNonCompliantCount(model.criticalNonCompliantCount);
            this.securityNonCompliantCount(model.securityNonCompliantCount);
            this.otherNonCompliantCount(model.otherNonCompliantCount);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getInstallOverrideList() {
            return this.installOverrideList;
        }

        public final void setInstallOverrideList(String installOverrideList) {
            this.installOverrideList = installOverrideList;
        }

        @Override
        public final Builder installOverrideList(String installOverrideList) {
            this.installOverrideList = installOverrideList;
            return this;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final Integer getInstalledCount() {
            return this.installedCount;
        }

        public final void setInstalledCount(Integer installedCount) {
            this.installedCount = installedCount;
        }

        @Override
        public final Builder installedCount(Integer installedCount) {
            this.installedCount = installedCount;
            return this;
        }

        public final Integer getInstalledOtherCount() {
            return this.installedOtherCount;
        }

        public final void setInstalledOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
        }

        @Override
        public final Builder installedOtherCount(Integer installedOtherCount) {
            this.installedOtherCount = installedOtherCount;
            return this;
        }

        public final Integer getInstalledPendingRebootCount() {
            return this.installedPendingRebootCount;
        }

        public final void setInstalledPendingRebootCount(Integer installedPendingRebootCount) {
            this.installedPendingRebootCount = installedPendingRebootCount;
        }

        @Override
        public final Builder installedPendingRebootCount(Integer installedPendingRebootCount) {
            this.installedPendingRebootCount = installedPendingRebootCount;
            return this;
        }

        public final Integer getInstalledRejectedCount() {
            return this.installedRejectedCount;
        }

        public final void setInstalledRejectedCount(Integer installedRejectedCount) {
            this.installedRejectedCount = installedRejectedCount;
        }

        @Override
        public final Builder installedRejectedCount(Integer installedRejectedCount) {
            this.installedRejectedCount = installedRejectedCount;
            return this;
        }

        public final Integer getMissingCount() {
            return this.missingCount;
        }

        public final void setMissingCount(Integer missingCount) {
            this.missingCount = missingCount;
        }

        @Override
        public final Builder missingCount(Integer missingCount) {
            this.missingCount = missingCount;
            return this;
        }

        public final Integer getFailedCount() {
            return this.failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final Integer getUnreportedNotApplicableCount() {
            return this.unreportedNotApplicableCount;
        }

        public final void setUnreportedNotApplicableCount(Integer unreportedNotApplicableCount) {
            this.unreportedNotApplicableCount = unreportedNotApplicableCount;
        }

        @Override
        public final Builder unreportedNotApplicableCount(Integer unreportedNotApplicableCount) {
            this.unreportedNotApplicableCount = unreportedNotApplicableCount;
            return this;
        }

        public final Integer getNotApplicableCount() {
            return this.notApplicableCount;
        }

        public final void setNotApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
        }

        @Override
        public final Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            return this;
        }

        public final Integer getAvailableSecurityUpdateCount() {
            return this.availableSecurityUpdateCount;
        }

        public final void setAvailableSecurityUpdateCount(Integer availableSecurityUpdateCount) {
            this.availableSecurityUpdateCount = availableSecurityUpdateCount;
        }

        @Override
        public final Builder availableSecurityUpdateCount(Integer availableSecurityUpdateCount) {
            this.availableSecurityUpdateCount = availableSecurityUpdateCount;
            return this;
        }

        public final Instant getOperationStartTime() {
            return this.operationStartTime;
        }

        public final void setOperationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
        }

        @Override
        public final Builder operationStartTime(Instant operationStartTime) {
            this.operationStartTime = operationStartTime;
            return this;
        }

        public final Instant getOperationEndTime() {
            return this.operationEndTime;
        }

        public final void setOperationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
        }

        @Override
        public final Builder operationEndTime(Instant operationEndTime) {
            this.operationEndTime = operationEndTime;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PatchOperationType operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Instant getLastNoRebootInstallOperationTime() {
            return this.lastNoRebootInstallOperationTime;
        }

        public final void setLastNoRebootInstallOperationTime(Instant lastNoRebootInstallOperationTime) {
            this.lastNoRebootInstallOperationTime = lastNoRebootInstallOperationTime;
        }

        @Override
        public final Builder lastNoRebootInstallOperationTime(Instant lastNoRebootInstallOperationTime) {
            this.lastNoRebootInstallOperationTime = lastNoRebootInstallOperationTime;
            return this;
        }

        public final String getRebootOption() {
            return this.rebootOption;
        }

        public final void setRebootOption(String rebootOption) {
            this.rebootOption = rebootOption;
        }

        @Override
        public final Builder rebootOption(String rebootOption) {
            this.rebootOption = rebootOption;
            return this;
        }

        @Override
        public final Builder rebootOption(RebootOption rebootOption) {
            this.rebootOption(rebootOption == null ? null : rebootOption.toString());
            return this;
        }

        public final Integer getCriticalNonCompliantCount() {
            return this.criticalNonCompliantCount;
        }

        public final void setCriticalNonCompliantCount(Integer criticalNonCompliantCount) {
            this.criticalNonCompliantCount = criticalNonCompliantCount;
        }

        @Override
        public final Builder criticalNonCompliantCount(Integer criticalNonCompliantCount) {
            this.criticalNonCompliantCount = criticalNonCompliantCount;
            return this;
        }

        public final Integer getSecurityNonCompliantCount() {
            return this.securityNonCompliantCount;
        }

        public final void setSecurityNonCompliantCount(Integer securityNonCompliantCount) {
            this.securityNonCompliantCount = securityNonCompliantCount;
        }

        @Override
        public final Builder securityNonCompliantCount(Integer securityNonCompliantCount) {
            this.securityNonCompliantCount = securityNonCompliantCount;
            return this;
        }

        public final Integer getOtherNonCompliantCount() {
            return this.otherNonCompliantCount;
        }

        public final void setOtherNonCompliantCount(Integer otherNonCompliantCount) {
            this.otherNonCompliantCount = otherNonCompliantCount;
        }

        @Override
        public final Builder otherNonCompliantCount(Integer otherNonCompliantCount) {
            this.otherNonCompliantCount = otherNonCompliantCount;
            return this;
        }

        public InstancePatchState build() {
            return new InstancePatchState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstancePatchState> {
        public Builder instanceId(String var1);

        public Builder patchGroup(String var1);

        public Builder baselineId(String var1);

        public Builder snapshotId(String var1);

        public Builder installOverrideList(String var1);

        public Builder ownerInformation(String var1);

        public Builder installedCount(Integer var1);

        public Builder installedOtherCount(Integer var1);

        public Builder installedPendingRebootCount(Integer var1);

        public Builder installedRejectedCount(Integer var1);

        public Builder missingCount(Integer var1);

        public Builder failedCount(Integer var1);

        public Builder unreportedNotApplicableCount(Integer var1);

        public Builder notApplicableCount(Integer var1);

        public Builder availableSecurityUpdateCount(Integer var1);

        public Builder operationStartTime(Instant var1);

        public Builder operationEndTime(Instant var1);

        public Builder operation(String var1);

        public Builder operation(PatchOperationType var1);

        public Builder lastNoRebootInstallOperationTime(Instant var1);

        public Builder rebootOption(String var1);

        public Builder rebootOption(RebootOption var1);

        public Builder criticalNonCompliantCount(Integer var1);

        public Builder securityNonCompliantCount(Integer var1);

        public Builder otherNonCompliantCount(Integer var1);
    }
}

