/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ManagedStatus {
    ALL("All"),
    MANAGED("Managed"),
    UNMANAGED("Unmanaged"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ManagedStatus> VALUE_MAP;
    private final String value;

    private ManagedStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ManagedStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ManagedStatus> knownValues() {
        EnumSet<ManagedStatus> knownValues = EnumSet.allOf(ManagedStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ManagedStatus.class, ManagedStatus::toString);
    }
}

