/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a compliance item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceItemEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceItemEntry.Builder, ComplianceItemEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ComplianceItemEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ComplianceItemEntry::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ComplianceItemEntry::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ComplianceItemEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Details")
            .getter(getter(ComplianceItemEntry::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            SEVERITY_FIELD, STATUS_FIELD, DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final String severity;

    private final String status;

    private final Map<String, String> details;

    private ComplianceItemEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.severity = builder.severity;
        this.status = builder.status;
        this.details = builder.details;
    }

    /**
     * <p>
     * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the
     * KB article.
     * </p>
     * 
     * @return The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the
     *         number of the KB article.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the
     * title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.
     * </p>
     * 
     * @return The title of the compliance item. For example, if the compliance item is a Windows patch, the title could
     *         be the title of the KB article for the patch; for example: Security Update for Active Directory
     *         Federation Services.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
     * Informational, Unspecified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
     *         Informational, Unspecified.
     * @see ComplianceSeverity
     */
    public final ComplianceSeverity severity() {
        return ComplianceSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
     * Informational, Unspecified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
     *         Informational, Unspecified.
     * @see ComplianceSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     * @see ComplianceStatus
     */
    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     * @see ComplianceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A "Key": "Value" tag combination for the compliance item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return A "Key": "Value" tag combination for the compliance item.
     */
    public final Map<String, String> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceItemEntry)) {
            return false;
        }
        ComplianceItemEntry other = (ComplianceItemEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComplianceItemEntry").add("Id", id()).add("Title", title()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("Details", hasDetails() ? details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComplianceItemEntry, T> g) {
        return obj -> g.apply((ComplianceItemEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceItemEntry> {
        /**
         * <p>
         * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of
         * the KB article.
         * </p>
         * 
         * @param id
         *        The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the
         *        number of the KB article.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be
         * the title of the KB article for the patch; for example: Security Update for Active Directory Federation
         * Services.
         * </p>
         * 
         * @param title
         *        The title of the compliance item. For example, if the compliance item is a Windows patch, the title
         *        could be the title of the KB article for the patch; for example: Security Update for Active Directory
         *        Federation Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
         * Informational, Unspecified.
         * </p>
         * 
         * @param severity
         *        The severity of the compliance status. Severity can be one of the following: Critical, High, Medium,
         *        Low, Informational, Unspecified.
         * @see ComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low,
         * Informational, Unspecified.
         * </p>
         * 
         * @param severity
         *        The severity of the compliance status. Severity can be one of the following: Critical, High, Medium,
         *        Low, Informational, Unspecified.
         * @see ComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceSeverity
         */
        Builder severity(ComplianceSeverity severity);

        /**
         * <p>
         * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         * </p>
         * 
         * @param status
         *        The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         * </p>
         * 
         * @param status
         *        The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder status(ComplianceStatus status);

        /**
         * <p>
         * A "Key": "Value" tag combination for the compliance item.
         * </p>
         * 
         * @param details
         *        A "Key": "Value" tag combination for the compliance item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Map<String, String> details);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private String severity;

        private String status;

        private Map<String, String> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceItemEntry model) {
            id(model.id);
            title(model.title);
            severity(model.severity);
            status(model.status);
            details(model.details);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ComplianceSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getDetails() {
            if (details instanceof SdkAutoConstructMap) {
                return null;
            }
            return details;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
            return this;
        }

        @Override
        public ComplianceItemEntry build() {
            return new ComplianceItemEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
