/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelMaintenanceWindowExecutionResponse extends SsmResponse implements
        ToCopyableBuilder<CancelMaintenanceWindowExecutionResponse.Builder, CancelMaintenanceWindowExecutionResponse> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowExecutionId").getter(getter(CancelMaintenanceWindowExecutionResponse::windowExecutionId))
            .setter(setter(Builder::windowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String windowExecutionId;

    private CancelMaintenanceWindowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
    }

    /**
     * <p>
     * The ID of the maintenance window execution that has been stopped.
     * </p>
     * 
     * @return The ID of the maintenance window execution that has been stopped.
     */
    public final String windowExecutionId() {
        return windowExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMaintenanceWindowExecutionResponse)) {
            return false;
        }
        CancelMaintenanceWindowExecutionResponse other = (CancelMaintenanceWindowExecutionResponse) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelMaintenanceWindowExecutionResponse").add("WindowExecutionId", windowExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.ofNullable(clazz.cast(windowExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WindowExecutionId", WINDOW_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelMaintenanceWindowExecutionResponse, T> g) {
        return obj -> g.apply((CancelMaintenanceWindowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelMaintenanceWindowExecutionResponse> {
        /**
         * <p>
         * The ID of the maintenance window execution that has been stopped.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the maintenance window execution that has been stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMaintenanceWindowExecutionResponse model) {
            super(model);
            windowExecutionId(model.windowExecutionId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        @Override
        public CancelMaintenanceWindowExecutionResponse build() {
            return new CancelMaintenanceWindowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
