/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview;
import software.amazon.awssdk.services.ssm.model.PingStatus;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InstanceProperty.getter(InstanceProperty::name)).setter(InstanceProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceProperty.getter(InstanceProperty::instanceId)).setter(InstanceProperty.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceProperty.getter(InstanceProperty::instanceType)).setter(InstanceProperty.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRole").getter(InstanceProperty.getter(InstanceProperty::instanceRole)).setter(InstanceProperty.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(InstanceProperty.getter(InstanceProperty::keyName)).setter(InstanceProperty.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceState").getter(InstanceProperty.getter(InstanceProperty::instanceState)).setter(InstanceProperty.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceState").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(InstanceProperty.getter(InstanceProperty::architecture)).setter(InstanceProperty.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddress").getter(InstanceProperty.getter(InstanceProperty::ipAddress)).setter(InstanceProperty.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(InstanceProperty.getter(InstanceProperty::launchTime)).setter(InstanceProperty.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<String> PING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PingStatus").getter(InstanceProperty.getter(InstanceProperty::pingStatusAsString)).setter(InstanceProperty.setter(Builder::pingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingStatus").build()}).build();
    private static final SdkField<Instant> LAST_PING_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastPingDateTime").getter(InstanceProperty.getter(InstanceProperty::lastPingDateTime)).setter(InstanceProperty.setter(Builder::lastPingDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPingDateTime").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentVersion").getter(InstanceProperty.getter(InstanceProperty::agentVersion)).setter(InstanceProperty.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformType").getter(InstanceProperty.getter(InstanceProperty::platformTypeAsString)).setter(InstanceProperty.setter(Builder::platformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()}).build();
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(InstanceProperty.getter(InstanceProperty::platformName)).setter(InstanceProperty.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(InstanceProperty.getter(InstanceProperty::platformVersion)).setter(InstanceProperty.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationId").getter(InstanceProperty.getter(InstanceProperty::activationId)).setter(InstanceProperty.setter(Builder::activationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRole").getter(InstanceProperty.getter(InstanceProperty::iamRole)).setter(InstanceProperty.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<Instant> REGISTRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RegistrationDate").getter(InstanceProperty.getter(InstanceProperty::registrationDate)).setter(InstanceProperty.setter(Builder::registrationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationDate").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(InstanceProperty.getter(InstanceProperty::resourceType)).setter(InstanceProperty.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputerName").getter(InstanceProperty.getter(InstanceProperty::computerName)).setter(InstanceProperty.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(InstanceProperty.getter(InstanceProperty::associationStatus)).setter(InstanceProperty.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<Instant> LAST_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAssociationExecutionDate").getter(InstanceProperty.getter(InstanceProperty::lastAssociationExecutionDate)).setter(InstanceProperty.setter(Builder::lastAssociationExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAssociationExecutionDate").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulAssociationExecutionDate").getter(InstanceProperty.getter(InstanceProperty::lastSuccessfulAssociationExecutionDate)).setter(InstanceProperty.setter(Builder::lastSuccessfulAssociationExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulAssociationExecutionDate").build()}).build();
    private static final SdkField<InstanceAggregatedAssociationOverview> ASSOCIATION_OVERVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationOverview").getter(InstanceProperty.getter(InstanceProperty::associationOverview)).setter(InstanceProperty.setter(Builder::associationOverview)).constructor(InstanceAggregatedAssociationOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationOverview").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(InstanceProperty.getter(InstanceProperty::sourceId)).setter(InstanceProperty.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(InstanceProperty.getter(InstanceProperty::sourceTypeAsString)).setter(InstanceProperty.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_ROLE_FIELD, KEY_NAME_FIELD, INSTANCE_STATE_FIELD, ARCHITECTURE_FIELD, IP_ADDRESS_FIELD, LAUNCH_TIME_FIELD, PING_STATUS_FIELD, LAST_PING_DATE_TIME_FIELD, AGENT_VERSION_FIELD, PLATFORM_TYPE_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, ACTIVATION_ID_FIELD, IAM_ROLE_FIELD, REGISTRATION_DATE_FIELD, RESOURCE_TYPE_FIELD, COMPUTER_NAME_FIELD, ASSOCIATION_STATUS_FIELD, LAST_ASSOCIATION_EXECUTION_DATE_FIELD, LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD, ASSOCIATION_OVERVIEW_FIELD, SOURCE_ID_FIELD, SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceProperty.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String instanceId;
    private final String instanceType;
    private final String instanceRole;
    private final String keyName;
    private final String instanceState;
    private final String architecture;
    private final String ipAddress;
    private final Instant launchTime;
    private final String pingStatus;
    private final Instant lastPingDateTime;
    private final String agentVersion;
    private final String platformType;
    private final String platformName;
    private final String platformVersion;
    private final String activationId;
    private final String iamRole;
    private final Instant registrationDate;
    private final String resourceType;
    private final String computerName;
    private final String associationStatus;
    private final Instant lastAssociationExecutionDate;
    private final Instant lastSuccessfulAssociationExecutionDate;
    private final InstanceAggregatedAssociationOverview associationOverview;
    private final String sourceId;
    private final String sourceType;

    private InstanceProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.instanceRole = builder.instanceRole;
        this.keyName = builder.keyName;
        this.instanceState = builder.instanceState;
        this.architecture = builder.architecture;
        this.ipAddress = builder.ipAddress;
        this.launchTime = builder.launchTime;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
        this.sourceId = builder.sourceId;
        this.sourceType = builder.sourceType;
    }

    public final String name() {
        return this.name;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String instanceRole() {
        return this.instanceRole;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String instanceState() {
        return this.instanceState;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final PingStatus pingStatus() {
        return PingStatus.fromValue(this.pingStatus);
    }

    public final String pingStatusAsString() {
        return this.pingStatus;
    }

    public final Instant lastPingDateTime() {
        return this.lastPingDateTime;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final PlatformType platformType() {
        return PlatformType.fromValue(this.platformType);
    }

    public final String platformTypeAsString() {
        return this.platformType;
    }

    public final String platformName() {
        return this.platformName;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String activationId() {
        return this.activationId;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final Instant registrationDate() {
        return this.registrationDate;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String computerName() {
        return this.computerName;
    }

    public final String associationStatus() {
        return this.associationStatus;
    }

    public final Instant lastAssociationExecutionDate() {
        return this.lastAssociationExecutionDate;
    }

    public final Instant lastSuccessfulAssociationExecutionDate() {
        return this.lastSuccessfulAssociationExecutionDate;
    }

    public final InstanceAggregatedAssociationOverview associationOverview() {
        return this.associationOverview;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPingDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationOverview());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProperty)) {
            return false;
        }
        InstanceProperty other = (InstanceProperty)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceRole(), other.instanceRole()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.instanceState(), other.instanceState()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.pingStatusAsString(), other.pingStatusAsString()) && Objects.equals(this.lastPingDateTime(), other.lastPingDateTime()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.platformTypeAsString(), other.platformTypeAsString()) && Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationDate(), other.registrationDate()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.associationStatus(), other.associationStatus()) && Objects.equals(this.lastAssociationExecutionDate(), other.lastAssociationExecutionDate()) && Objects.equals(this.lastSuccessfulAssociationExecutionDate(), other.lastSuccessfulAssociationExecutionDate()) && Objects.equals(this.associationOverview(), other.associationOverview()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceProperty").add("Name", (Object)this.name()).add("InstanceId", (Object)this.instanceId()).add("InstanceType", (Object)this.instanceType()).add("InstanceRole", (Object)this.instanceRole()).add("KeyName", (Object)this.keyName()).add("InstanceState", (Object)this.instanceState()).add("Architecture", (Object)this.architecture()).add("IPAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("LaunchTime", (Object)this.launchTime()).add("PingStatus", (Object)this.pingStatusAsString()).add("LastPingDateTime", (Object)this.lastPingDateTime()).add("AgentVersion", (Object)this.agentVersion()).add("PlatformType", (Object)this.platformTypeAsString()).add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("ActivationId", (Object)this.activationId()).add("IamRole", (Object)this.iamRole()).add("RegistrationDate", (Object)this.registrationDate()).add("ResourceType", (Object)this.resourceType()).add("ComputerName", (Object)this.computerName()).add("AssociationStatus", (Object)this.associationStatus()).add("LastAssociationExecutionDate", (Object)this.lastAssociationExecutionDate()).add("LastSuccessfulAssociationExecutionDate", (Object)this.lastSuccessfulAssociationExecutionDate()).add("AssociationOverview", (Object)this.associationOverview()).add("SourceId", (Object)this.sourceId()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRole()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceState()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "IPAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "PingStatus": {
                return Optional.ofNullable(clazz.cast(this.pingStatusAsString()));
            }
            case "LastPingDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastPingDateTime()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "PlatformType": {
                return Optional.ofNullable(clazz.cast(this.platformTypeAsString()));
            }
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ActivationId": {
                return Optional.ofNullable(clazz.cast(this.activationId()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "RegistrationDate": {
                return Optional.ofNullable(clazz.cast(this.registrationDate()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatus()));
            }
            case "LastAssociationExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastAssociationExecutionDate()));
            }
            case "LastSuccessfulAssociationExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulAssociationExecutionDate()));
            }
            case "AssociationOverview": {
                return Optional.ofNullable(clazz.cast(this.associationOverview()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceRole", INSTANCE_ROLE_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("InstanceState", INSTANCE_STATE_FIELD);
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("IPAddress", IP_ADDRESS_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("PingStatus", PING_STATUS_FIELD);
        map.put("LastPingDateTime", LAST_PING_DATE_TIME_FIELD);
        map.put("AgentVersion", AGENT_VERSION_FIELD);
        map.put("PlatformType", PLATFORM_TYPE_FIELD);
        map.put("PlatformName", PLATFORM_NAME_FIELD);
        map.put("PlatformVersion", PLATFORM_VERSION_FIELD);
        map.put("ActivationId", ACTIVATION_ID_FIELD);
        map.put("IamRole", IAM_ROLE_FIELD);
        map.put("RegistrationDate", REGISTRATION_DATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ComputerName", COMPUTER_NAME_FIELD);
        map.put("AssociationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("LastAssociationExecutionDate", LAST_ASSOCIATION_EXECUTION_DATE_FIELD);
        map.put("LastSuccessfulAssociationExecutionDate", LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD);
        map.put("AssociationOverview", ASSOCIATION_OVERVIEW_FIELD);
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceProperty, T> g) {
        return obj -> g.apply((InstanceProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private String instanceType;
        private String instanceRole;
        private String keyName;
        private String instanceState;
        private String architecture;
        private String ipAddress;
        private Instant launchTime;
        private String pingStatus;
        private Instant lastPingDateTime;
        private String agentVersion;
        private String platformType;
        private String platformName;
        private String platformVersion;
        private String activationId;
        private String iamRole;
        private Instant registrationDate;
        private String resourceType;
        private String computerName;
        private String associationStatus;
        private Instant lastAssociationExecutionDate;
        private Instant lastSuccessfulAssociationExecutionDate;
        private InstanceAggregatedAssociationOverview associationOverview;
        private String sourceId;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProperty model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.instanceType(model.instanceType);
            this.instanceRole(model.instanceRole);
            this.keyName(model.keyName);
            this.instanceState(model.instanceState);
            this.architecture(model.architecture);
            this.ipAddress(model.ipAddress);
            this.launchTime(model.launchTime);
            this.pingStatus(model.pingStatus);
            this.lastPingDateTime(model.lastPingDateTime);
            this.agentVersion(model.agentVersion);
            this.platformType(model.platformType);
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.activationId(model.activationId);
            this.iamRole(model.iamRole);
            this.registrationDate(model.registrationDate);
            this.resourceType(model.resourceType);
            this.computerName(model.computerName);
            this.associationStatus(model.associationStatus);
            this.lastAssociationExecutionDate(model.lastAssociationExecutionDate);
            this.lastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            this.associationOverview(model.associationOverview);
            this.sourceId(model.sourceId);
            this.sourceType(model.sourceType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final String getPingStatus() {
            return this.pingStatus;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus == null ? null : pingStatus.toString());
            return this;
        }

        public final Instant getLastPingDateTime() {
            return this.lastPingDateTime;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getPlatformType() {
            return this.platformType;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType == null ? null : platformType.toString());
            return this;
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getActivationId() {
            return this.activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Instant getRegistrationDate() {
            return this.registrationDate;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final Instant getLastAssociationExecutionDate() {
            return this.lastAssociationExecutionDate;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return this.lastSuccessfulAssociationExecutionDate;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final InstanceAggregatedAssociationOverview.Builder getAssociationOverview() {
            return this.associationOverview != null ? this.associationOverview.toBuilder() : null;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview.BuilderImpl associationOverview) {
            this.associationOverview = associationOverview != null ? associationOverview.build() : null;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public InstanceProperty build() {
            return new InstanceProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceProperty> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceRole(String var1);

        public Builder keyName(String var1);

        public Builder instanceState(String var1);

        public Builder architecture(String var1);

        public Builder ipAddress(String var1);

        public Builder launchTime(Instant var1);

        public Builder pingStatus(String var1);

        public Builder pingStatus(PingStatus var1);

        public Builder lastPingDateTime(Instant var1);

        public Builder agentVersion(String var1);

        public Builder platformType(String var1);

        public Builder platformType(PlatformType var1);

        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder activationId(String var1);

        public Builder iamRole(String var1);

        public Builder registrationDate(Instant var1);

        public Builder resourceType(String var1);

        public Builder computerName(String var1);

        public Builder associationStatus(String var1);

        public Builder lastAssociationExecutionDate(Instant var1);

        public Builder lastSuccessfulAssociationExecutionDate(Instant var1);

        public Builder associationOverview(InstanceAggregatedAssociationOverview var1);

        default public Builder associationOverview(Consumer<InstanceAggregatedAssociationOverview.Builder> associationOverview) {
            return this.associationOverview((InstanceAggregatedAssociationOverview)((InstanceAggregatedAssociationOverview.Builder)InstanceAggregatedAssociationOverview.builder().applyMutation(associationOverview)).build());
        }

        public Builder sourceId(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);
    }
}

