/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association of a Amazon Web Services Systems Manager document (SSM document) and a managed node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssociationBatchRequestEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAssociationBatchRequestEntry.Builder, CreateAssociationBatchRequestEntry> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAssociationBatchRequestEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateAssociationBatchRequestEntry::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CreateAssociationBatchRequestEntry::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> AUTOMATION_TARGET_PARAMETER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutomationTargetParameterName")
            .getter(getter(CreateAssociationBatchRequestEntry::automationTargetParameterName))
            .setter(setter(Builder::automationTargetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationTargetParameterName")
                    .build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(CreateAssociationBatchRequestEntry::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(CreateAssociationBatchRequestEntry::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(CreateAssociationBatchRequestEntry::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<InstanceAssociationOutputLocation> builder(MarshallingType.SDK_POJO).memberName("OutputLocation")
            .getter(getter(CreateAssociationBatchRequestEntry::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(InstanceAssociationOutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationName").getter(getter(CreateAssociationBatchRequestEntry::associationName))
            .setter(setter(Builder::associationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(CreateAssociationBatchRequestEntry::maxErrors))
            .setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(CreateAssociationBatchRequestEntry::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceSeverity").getter(getter(CreateAssociationBatchRequestEntry::complianceSeverityAsString))
            .setter(setter(Builder::complianceSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build())
            .build();

    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncCompliance").getter(getter(CreateAssociationBatchRequestEntry::syncComplianceAsString))
            .setter(setter(Builder::syncCompliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()).build();

    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval")
            .getter(getter(CreateAssociationBatchRequestEntry::applyOnlyAtCronInterval))
            .setter(setter(Builder::applyOnlyAtCronInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build())
            .build();

    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CalendarNames")
            .getter(getter(CreateAssociationBatchRequestEntry::calendarNames))
            .setter(setter(Builder::calendarNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .memberName("TargetLocations")
            .getter(getter(CreateAssociationBatchRequestEntry::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScheduleOffset").getter(getter(CreateAssociationBatchRequestEntry::scheduleOffset))
            .setter(setter(Builder::scheduleOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(CreateAssociationBatchRequestEntry::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField
            .<List<Map<String, List<String>>>> builder(MarshallingType.LIST)
            .memberName("TargetMaps")
            .getter(getter(CreateAssociationBatchRequestEntry::targetMaps))
            .setter(setter(Builder::targetMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("AlarmConfiguration")
            .getter(getter(CreateAssociationBatchRequestEntry::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_ID_FIELD,
            PARAMETERS_FIELD, AUTOMATION_TARGET_PARAMETER_NAME_FIELD, DOCUMENT_VERSION_FIELD, TARGETS_FIELD,
            SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, ASSOCIATION_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD,
            COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD, APPLY_ONLY_AT_CRON_INTERVAL_FIELD, CALENDAR_NAMES_FIELD,
            TARGET_LOCATIONS_FIELD, SCHEDULE_OFFSET_FIELD, DURATION_FIELD, TARGET_MAPS_FIELD, ALARM_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String instanceId;

    private final Map<String, List<String>> parameters;

    private final String automationTargetParameterName;

    private final String documentVersion;

    private final List<Target> targets;

    private final String scheduleExpression;

    private final InstanceAssociationOutputLocation outputLocation;

    private final String associationName;

    private final String maxErrors;

    private final String maxConcurrency;

    private final String complianceSeverity;

    private final String syncCompliance;

    private final Boolean applyOnlyAtCronInterval;

    private final List<String> calendarNames;

    private final List<TargetLocation> targetLocations;

    private final Integer scheduleOffset;

    private final Integer duration;

    private final List<Map<String, List<String>>> targetMaps;

    private final AlarmConfiguration alarmConfiguration;

    private CreateAssociationBatchRequestEntry(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.parameters = builder.parameters;
        this.automationTargetParameterName = builder.automationTargetParameterName;
        this.documentVersion = builder.documentVersion;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.associationName = builder.associationName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
        this.calendarNames = builder.calendarNames;
        this.targetLocations = builder.targetLocations;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.targetMaps = builder.targetMaps;
        this.alarmConfiguration = builder.alarmConfiguration;
    }

    /**
     * <p>
     * The name of the SSM document that contains the configuration information for the managed node. You can specify
     * Command or Automation runbooks.
     * </p>
     * <p>
     * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared
     * with you from another account.
     * </p>
     * <p>
     * For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the complete
     * SSM document ARN, in the following format:
     * </p>
     * <p>
     * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
     * </p>
     * <p>
     * For example:
     * </p>
     * <p>
     * <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
     * </p>
     * <p>
     * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to
     * specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
     * </p>
     * 
     * @return The name of the SSM document that contains the configuration information for the managed node. You can
     *         specify Command or Automation runbooks.</p>
     *         <p>
     *         You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
     *         shared with you from another account.
     *         </p>
     *         <p>
     *         For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the
     *         complete SSM document ARN, in the following format:
     *         </p>
     *         <p>
     *         <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <p>
     *         <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
     *         </p>
     *         <p>
     *         For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
     *         to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
     *         <code>My-Document</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The managed node ID.
     * </p>
     * <note>
     * <p>
     * <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the
     * <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems Manager
     * documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter
     * <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>,
     * <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or
     * <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.
     * </p>
     * </note>
     * 
     * @return The managed node ID.</p> <note>
     *         <p>
     *         <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the
     *         <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems
     *         Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use
     *         the parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
     *         <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
     *         <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use
     *         the <code>Targets</code> parameter.
     *         </p>
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A description of the parameters for a document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A description of the parameters for a document.
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Specify the target for the association. This target is required for associations that use an Automation runbook
     * and target resources by using rate controls. Automation is a tool in Amazon Web Services Systems Manager.
     * </p>
     * 
     * @return Specify the target for the association. This target is required for associations that use an Automation
     *         runbook and target resources by using rate controls. Automation is a tool in Amazon Web Services Systems
     *         Manager.
     */
    public final String automationTargetParameterName() {
        return automationTargetParameterName;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The managed nodes targeted by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The managed nodes targeted by the request.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * A cron expression that specifies a schedule when the association runs.
     * </p>
     * 
     * @return A cron expression that specifies a schedule when the association runs.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * An S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return An S3 bucket where you want to store the results of this request.
     */
    public final InstanceAssociationOutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * Specify a descriptive name for the association.
     * </p>
     * 
     * @return Specify a descriptive name for the association.
     */
    public final String associationName() {
        return associationName;
    }

    /**
     * <p>
     * The number of errors that are allowed before the system stops sending requests to run the association on
     * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the
     * target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth
     * error is received. If you specify 0, then the system stops sending requests after the first error is returned. If
     * you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending
     * the request when the sixth error is received.
     * </p>
     * <p>
     * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
     * complete, but some of these executions may fail as well. If you need to ensure that there won't be more than
     * max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
     * </p>
     * 
     * @return The number of errors that are allowed before the system stops sending requests to run the association on
     *         additional targets. You can specify either an absolute number of errors, for example 10, or a percentage
     *         of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when
     *         the fourth error is received. If you specify 0, then the system stops sending requests after the first
     *         error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%,
     *         then the system stops sending the request when the sixth error is received.</p>
     *         <p>
     *         Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
     *         complete, but some of these executions may fail as well. If you need to ensure that there won't be more
     *         than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at
     *         a time.
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
     * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
     * targets run the association at the same time.
     * </p>
     * <p>
     * If a new managed node starts and attempts to run an association while Systems Manager is running
     * <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
     * interval, the new managed node will process its association within the limit specified for
     * <code>MaxConcurrency</code>.
     * </p>
     * 
     * @return The maximum number of targets allowed to run the association at the same time. You can specify a number,
     *         for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which
     *         means all targets run the association at the same time.</p>
     *         <p>
     *         If a new managed node starts and attempts to run an association while Systems Manager is running
     *         <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
     *         interval, the new managed node will process its association within the limit specified for
     *         <code>MaxConcurrency</code>.
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The severity level to assign to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level to assign to the association.
     * @see AssociationComplianceSeverity
     */
    public final AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(complianceSeverity);
    }

    /**
     * <p>
     * The severity level to assign to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level to assign to the association.
     * @see AssociationComplianceSeverity
     */
    public final String complianceSeverityAsString() {
        return complianceSeverity;
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a tool in
     * Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API
     * operation.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>. </p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     *         tool in Amazon Web Services Systems Manager. It is managed by your direct call to the
     *         <a>PutComplianceItems</a> API operation.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(syncCompliance);
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a tool in
     * Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API
     * operation.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>. </p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     *         tool in Amazon Web Services Systems Manager. It is managed by your direct call to the
     *         <a>PutComplianceItems</a> API operation.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final String syncComplianceAsString() {
        return syncCompliance;
    }

    /**
     * <p>
     * By default, when you create a new association, the system runs it immediately after it is created and then
     * according to the schedule you specified and when target changes are detected. Specify <code>true</code> for
     * <code>ApplyOnlyAtCronInterval</code> if you want the association to run only according to the schedule you
     * specified.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling"
     * >Understanding when associations are applied to resources</a> and <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates"
     * >&gt;About target updates with Automation runbooks</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * <p>
     * This parameter isn't supported for rate expressions.
     * </p>
     * 
     * @return By default, when you create a new association, the system runs it immediately after it is created and
     *         then according to the schedule you specified and when target changes are detected. Specify
     *         <code>true</code> for <code>ApplyOnlyAtCronInterval</code> if you want the association to run only
     *         according to the schedule you specified.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling"
     *         >Understanding when associations are applied to resources</a> and <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates"
     *         >&gt;About target updates with Automation runbooks</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         This parameter isn't supported for rate expressions.
     */
    public final Boolean applyOnlyAtCronInterval() {
        return applyOnlyAtCronInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalendarNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalendarNames() {
        return calendarNames != null && !(calendarNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
     * under. The associations only run when that Change Calendar is open. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web
     * Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalendarNames} method.
     * </p>
     * 
     * @return The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
     *         gated under. The associations only run when that Change Calendar is open. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
     *         Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.
     */
    public final List<String> calendarNames() {
        return calendarNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetLocations() {
        return targetLocations != null && !(targetLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this action to create an association in multiple Regions and multiple accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetLocations} method.
     * </p>
     * 
     * @return Use this action to create an association in multiple Regions and multiple accounts.
     */
    public final List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    /**
     * <p>
     * Number of days to wait after the scheduled day to run an association.
     * </p>
     * 
     * @return Number of days to wait after the scheduled day to run an association.
     */
    public final Integer scheduleOffset() {
        return scheduleOffset;
    }

    /**
     * <p>
     * The number of hours the association can run before it is canceled. Duration applies to associations that are
     * currently running, and any pending and in progress commands on all targets. If a target was taken offline for the
     * association to run, it is made available again immediately, without a reboot.
     * </p>
     * <p>
     * The <code>Duration</code> parameter applies only when both these conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The association for which you specify a duration is cancelable according to the parameters of the SSM command
     * document or Automation runbook associated with this execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * The command specifies the
     * <code> <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociationBatchRequestEntry.html#systemsmanager-Type-CreateAssociationBatchRequestEntry-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> </code>
     * parameter, which means that the association doesn't run immediately after it is created, but only according to
     * the specified schedule.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of hours the association can run before it is canceled. Duration applies to associations that
     *         are currently running, and any pending and in progress commands on all targets. If a target was taken
     *         offline for the association to run, it is made available again immediately, without a reboot. </p>
     *         <p>
     *         The <code>Duration</code> parameter applies only when both these conditions are true:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The association for which you specify a duration is cancelable according to the parameters of the SSM
     *         command document or Automation runbook associated with this execution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The command specifies the
     *         <code> <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociationBatchRequestEntry.html#systemsmanager-Type-CreateAssociationBatchRequestEntry-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> </code>
     *         parameter, which means that the association doesn't run immediately after it is created, but only
     *         according to the specified schedule.
     *         </p>
     *         </li>
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetMaps() {
        return targetMaps != null && !(targetMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified
     * together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetMaps} method.
     * </p>
     * 
     * @return A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
     *         specified together.
     */
    public final List<Map<String, List<String>>> targetMaps() {
        return targetMaps;
    }

    /**
     * Returns the value of the AlarmConfiguration property for this object.
     * 
     * @return The value of the AlarmConfiguration property for this object.
     */
    public final AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(automationTargetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(associationName());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyOnlyAtCronInterval());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalendarNames() ? calendarNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLocations() ? targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetMaps() ? targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchRequestEntry)) {
            return false;
        }
        CreateAssociationBatchRequestEntry other = (CreateAssociationBatchRequestEntry) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceId(), other.instanceId())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(automationTargetParameterName(), other.automationTargetParameterName())
                && Objects.equals(documentVersion(), other.documentVersion()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(associationName(), other.associationName()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(complianceSeverityAsString(), other.complianceSeverityAsString())
                && Objects.equals(syncComplianceAsString(), other.syncComplianceAsString())
                && Objects.equals(applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval())
                && hasCalendarNames() == other.hasCalendarNames() && Objects.equals(calendarNames(), other.calendarNames())
                && hasTargetLocations() == other.hasTargetLocations()
                && Objects.equals(targetLocations(), other.targetLocations())
                && Objects.equals(scheduleOffset(), other.scheduleOffset()) && Objects.equals(duration(), other.duration())
                && hasTargetMaps() == other.hasTargetMaps() && Objects.equals(targetMaps(), other.targetMaps())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssociationBatchRequestEntry").add("Name", name()).add("InstanceId", instanceId())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AutomationTargetParameterName", automationTargetParameterName()).add("DocumentVersion", documentVersion())
                .add("Targets", hasTargets() ? targets() : null).add("ScheduleExpression", scheduleExpression())
                .add("OutputLocation", outputLocation()).add("AssociationName", associationName()).add("MaxErrors", maxErrors())
                .add("MaxConcurrency", maxConcurrency()).add("ComplianceSeverity", complianceSeverityAsString())
                .add("SyncCompliance", syncComplianceAsString()).add("ApplyOnlyAtCronInterval", applyOnlyAtCronInterval())
                .add("CalendarNames", hasCalendarNames() ? calendarNames() : null)
                .add("TargetLocations", hasTargetLocations() ? targetLocations() : null).add("ScheduleOffset", scheduleOffset())
                .add("Duration", duration()).add("TargetMaps", hasTargetMaps() ? targetMaps() : null)
                .add("AlarmConfiguration", alarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "AutomationTargetParameterName":
            return Optional.ofNullable(clazz.cast(automationTargetParameterName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "AssociationName":
            return Optional.ofNullable(clazz.cast(associationName()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "ComplianceSeverity":
            return Optional.ofNullable(clazz.cast(complianceSeverityAsString()));
        case "SyncCompliance":
            return Optional.ofNullable(clazz.cast(syncComplianceAsString()));
        case "ApplyOnlyAtCronInterval":
            return Optional.ofNullable(clazz.cast(applyOnlyAtCronInterval()));
        case "CalendarNames":
            return Optional.ofNullable(clazz.cast(calendarNames()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        case "ScheduleOffset":
            return Optional.ofNullable(clazz.cast(scheduleOffset()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "TargetMaps":
            return Optional.ofNullable(clazz.cast(targetMaps()));
        case "AlarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("AutomationTargetParameterName", AUTOMATION_TARGET_PARAMETER_NAME_FIELD);
        map.put("DocumentVersion", DOCUMENT_VERSION_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("AssociationName", ASSOCIATION_NAME_FIELD);
        map.put("MaxErrors", MAX_ERRORS_FIELD);
        map.put("MaxConcurrency", MAX_CONCURRENCY_FIELD);
        map.put("ComplianceSeverity", COMPLIANCE_SEVERITY_FIELD);
        map.put("SyncCompliance", SYNC_COMPLIANCE_FIELD);
        map.put("ApplyOnlyAtCronInterval", APPLY_ONLY_AT_CRON_INTERVAL_FIELD);
        map.put("CalendarNames", CALENDAR_NAMES_FIELD);
        map.put("TargetLocations", TARGET_LOCATIONS_FIELD);
        map.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("TargetMaps", TARGET_MAPS_FIELD);
        map.put("AlarmConfiguration", ALARM_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssociationBatchRequestEntry, T> g) {
        return obj -> g.apply((CreateAssociationBatchRequestEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAssociationBatchRequestEntry> {
        /**
         * <p>
         * The name of the SSM document that contains the configuration information for the managed node. You can
         * specify Command or Automation runbooks.
         * </p>
         * <p>
         * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared
         * with you from another account.
         * </p>
         * <p>
         * For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the
         * complete SSM document ARN, in the following format:
         * </p>
         * <p>
         * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
         * </p>
         * <p>
         * For example:
         * </p>
         * <p>
         * <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         * </p>
         * <p>
         * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to
         * specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
         * </p>
         * 
         * @param name
         *        The name of the SSM document that contains the configuration information for the managed node. You can
         *        specify Command or Automation runbooks.</p>
         *        <p>
         *        You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
         *        shared with you from another account.
         *        </p>
         *        <p>
         *        For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify
         *        the complete SSM document ARN, in the following format:
         *        </p>
         *        <p>
         *        <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <p>
         *        <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         *        </p>
         *        <p>
         *        For Amazon Web Services-predefined documents and SSM documents you created in your account, you only
         *        need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or
         *        <code>My-Document</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The managed node ID.
         * </p>
         * <note>
         * <p>
         * <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the
         * <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with Systems
         * Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the
         * parameter <code>InstanceId</code>, you can't use the parameters <code>AssociationName</code>,
         * <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>,
         * <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the
         * <code>Targets</code> parameter.
         * </p>
         * </note>
         * 
         * @param instanceId
         *        The managed node ID.</p> <note>
         *        <p>
         *        <code>InstanceId</code> has been deprecated. To specify a managed node ID for an association, use the
         *        <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with
         *        Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition,
         *        if you use the parameter <code>InstanceId</code>, you can't use the parameters
         *        <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>,
         *        <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use
         *        these parameters, you must use the <code>Targets</code> parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A description of the parameters for a document.
         * </p>
         * 
         * @param parameters
         *        A description of the parameters for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * Specify the target for the association. This target is required for associations that use an Automation
         * runbook and target resources by using rate controls. Automation is a tool in Amazon Web Services Systems
         * Manager.
         * </p>
         * 
         * @param automationTargetParameterName
         *        Specify the target for the association. This target is required for associations that use an
         *        Automation runbook and target resources by using rate controls. Automation is a tool in Amazon Web
         *        Services Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationTargetParameterName(String automationTargetParameterName);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * 
         * @param targets
         *        The managed nodes targeted by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * 
         * @param targets
         *        The managed nodes targeted by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Target.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Target.Builder#build()}
         * is called immediately and its result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * A cron expression that specifies a schedule when the association runs.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression that specifies a schedule when the association runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * An S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputLocation
         *        An S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(InstanceAssociationOutputLocation outputLocation);

        /**
         * <p>
         * An S3 bucket where you want to store the results of this request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceAssociationOutputLocation.Builder} avoiding the need to create one manually via
         * {@link InstanceAssociationOutputLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceAssociationOutputLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #outputLocation(InstanceAssociationOutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link InstanceAssociationOutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(InstanceAssociationOutputLocation)
         */
        default Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return outputLocation(InstanceAssociationOutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * Specify a descriptive name for the association.
         * </p>
         * 
         * @param associationName
         *        Specify a descriptive name for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationName(String associationName);

        /**
         * <p>
         * The number of errors that are allowed before the system stops sending requests to run the association on
         * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of
         * the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the
         * fourth error is received. If you specify 0, then the system stops sending requests after the first error is
         * returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system
         * stops sending the request when the sixth error is received.
         * </p>
         * <p>
         * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
         * complete, but some of these executions may fail as well. If you need to ensure that there won't be more than
         * max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
         * </p>
         * 
         * @param maxErrors
         *        The number of errors that are allowed before the system stops sending requests to run the association
         *        on additional targets. You can specify either an absolute number of errors, for example 10, or a
         *        percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending
         *        requests when the fourth error is received. If you specify 0, then the system stops sending requests
         *        after the first error is returned. If you run an association on 50 managed nodes and set
         *        <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is
         *        received.</p>
         *        <p>
         *        Executions that are already running an association when <code>MaxErrors</code> is reached are allowed
         *        to complete, but some of these executions may fail as well. If you need to ensure that there won't be
         *        more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions
         *        proceed one at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
         * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
         * targets run the association at the same time.
         * </p>
         * <p>
         * If a new managed node starts and attempts to run an association while Systems Manager is running
         * <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
         * interval, the new managed node will process its association within the limit specified for
         * <code>MaxConcurrency</code>.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run the association at the same time. You can specify a
         *        number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%,
         *        which means all targets run the association at the same time.</p>
         *        <p>
         *        If a new managed node starts and attempts to run an association while Systems Manager is running
         *        <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
         *        association interval, the new managed node will process its association within the limit specified for
         *        <code>MaxConcurrency</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The severity level to assign to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level to assign to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(String complianceSeverity);

        /**
         * <p>
         * The severity level to assign to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level to assign to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a tool
         * in Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a>
         * API operation.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>. </p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager,
         *        a tool in Amazon Web Services Systems Manager. It is managed by your direct call to the
         *        <a>PutComplianceItems</a> API operation.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(String syncCompliance);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a tool
         * in Amazon Web Services Systems Manager. It is managed by your direct call to the <a>PutComplianceItems</a>
         * API operation.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>. </p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager,
         *        a tool in Amazon Web Services Systems Manager. It is managed by your direct call to the
         *        <a>PutComplianceItems</a> API operation.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(AssociationSyncCompliance syncCompliance);

        /**
         * <p>
         * By default, when you create a new association, the system runs it immediately after it is created and then
         * according to the schedule you specified and when target changes are detected. Specify <code>true</code> for
         * <code>ApplyOnlyAtCronInterval</code> if you want the association to run only according to the schedule you
         * specified.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling"
         * >Understanding when associations are applied to resources</a> and <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates"
         * >&gt;About target updates with Automation runbooks</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * <p>
         * This parameter isn't supported for rate expressions.
         * </p>
         * 
         * @param applyOnlyAtCronInterval
         *        By default, when you create a new association, the system runs it immediately after it is created and
         *        then according to the schedule you specified and when target changes are detected. Specify
         *        <code>true</code> for <code>ApplyOnlyAtCronInterval</code> if you want the association to run only
         *        according to the schedule you specified.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#state-manager-about-scheduling"
         *        >Understanding when associations are applied to resources</a> and <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/state-manager-about.html#runbook-target-updates"
         *        >&gt;About target updates with Automation runbooks</a> in the <i>Amazon Web Services Systems Manager
         *        User Guide</i>.
         *        </p>
         *        <p>
         *        This parameter isn't supported for rate expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval);

        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
         * under. The associations only run when that Change Calendar is open. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
         * Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
         *        gated under. The associations only run when that Change Calendar is open. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">
         *        Amazon Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(Collection<String> calendarNames);

        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
         * under. The associations only run when that Change Calendar is open. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
         * Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User
         * Guide</i>.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
         *        gated under. The associations only run when that Change Calendar is open. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">
         *        Amazon Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(String... calendarNames);

        /**
         * <p>
         * Use this action to create an association in multiple Regions and multiple accounts.
         * </p>
         * 
         * @param targetLocations
         *        Use this action to create an association in multiple Regions and multiple accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * Use this action to create an association in multiple Regions and multiple accounts.
         * </p>
         * 
         * @param targetLocations
         *        Use this action to create an association in multiple Regions and multiple accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * Use this action to create an association in multiple Regions and multiple accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.TargetLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.TargetLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(java.util.Collection<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);

        /**
         * <p>
         * Number of days to wait after the scheduled day to run an association.
         * </p>
         * 
         * @param scheduleOffset
         *        Number of days to wait after the scheduled day to run an association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleOffset(Integer scheduleOffset);

        /**
         * <p>
         * The number of hours the association can run before it is canceled. Duration applies to associations that are
         * currently running, and any pending and in progress commands on all targets. If a target was taken offline for
         * the association to run, it is made available again immediately, without a reboot.
         * </p>
         * <p>
         * The <code>Duration</code> parameter applies only when both these conditions are true:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The association for which you specify a duration is cancelable according to the parameters of the SSM command
         * document or Automation runbook associated with this execution.
         * </p>
         * </li>
         * <li>
         * <p>
         * The command specifies the
         * <code> <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociationBatchRequestEntry.html#systemsmanager-Type-CreateAssociationBatchRequestEntry-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> </code>
         * parameter, which means that the association doesn't run immediately after it is created, but only according
         * to the specified schedule.
         * </p>
         * </li>
         * </ul>
         * 
         * @param duration
         *        The number of hours the association can run before it is canceled. Duration applies to associations
         *        that are currently running, and any pending and in progress commands on all targets. If a target was
         *        taken offline for the association to run, it is made available again immediately, without a reboot.
         *        </p>
         *        <p>
         *        The <code>Duration</code> parameter applies only when both these conditions are true:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The association for which you specify a duration is cancelable according to the parameters of the SSM
         *        command document or Automation runbook associated with this execution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The command specifies the
         *        <code> <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_CreateAssociationBatchRequestEntry.html#systemsmanager-Type-CreateAssociationBatchRequestEntry-ApplyOnlyAtCronInterval">ApplyOnlyAtCronInterval</a> </code>
         *        parameter, which means that the association doesn't run immediately after it is created, but only
         *        according to the specified schedule.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps);

        /**
         * Sets the value of the AlarmConfiguration property for this object.
         *
         * @param alarmConfiguration
         *        The new value for the AlarmConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * Sets the value of the AlarmConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String instanceId;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String automationTargetParameterName;

        private String documentVersion;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String scheduleExpression;

        private InstanceAssociationOutputLocation outputLocation;

        private String associationName;

        private String maxErrors;

        private String maxConcurrency;

        private String complianceSeverity;

        private String syncCompliance;

        private Boolean applyOnlyAtCronInterval;

        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private Integer scheduleOffset;

        private Integer duration;

        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();

        private AlarmConfiguration alarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchRequestEntry model) {
            name(model.name);
            instanceId(model.instanceId);
            parameters(model.parameters);
            automationTargetParameterName(model.automationTargetParameterName);
            documentVersion(model.documentVersion);
            targets(model.targets);
            scheduleExpression(model.scheduleExpression);
            outputLocation(model.outputLocation);
            associationName(model.associationName);
            maxErrors(model.maxErrors);
            maxConcurrency(model.maxConcurrency);
            complianceSeverity(model.complianceSeverity);
            syncCompliance(model.syncCompliance);
            applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
            calendarNames(model.calendarNames);
            targetLocations(model.targetLocations);
            scheduleOffset(model.scheduleOffset);
            duration(model.duration);
            targetMaps(model.targetMaps);
            alarmConfiguration(model.alarmConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final String getAutomationTargetParameterName() {
            return automationTargetParameterName;
        }

        public final void setAutomationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
        }

        @Override
        public final Builder automationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getAssociationName() {
            return associationName;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getComplianceSeverity() {
            return complianceSeverity;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final String getSyncCompliance() {
            return syncCompliance;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        @Override
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return applyOnlyAtCronInterval;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        @Override
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final Collection<String> getCalendarNames() {
            if (calendarNames instanceof SdkAutoConstructList) {
                return null;
            }
            return calendarNames;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        @Override
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calendarNames(String... calendarNames) {
            calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getScheduleOffset() {
            return scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps) {
            targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        @Override
        public CreateAssociationBatchRequestEntry build() {
            return new CreateAssociationBatchRequestEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
