/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentRequires
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentRequires> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DocumentRequires.getter(DocumentRequires::name)).setter(DocumentRequires.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(DocumentRequires.getter(DocumentRequires::version)).setter(DocumentRequires.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> REQUIRE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequireType").getter(DocumentRequires.getter(DocumentRequires::requireType)).setter(DocumentRequires.setter(Builder::requireType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireType").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(DocumentRequires.getter(DocumentRequires::versionName)).setter(DocumentRequires.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, REQUIRE_TYPE_FIELD, VERSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentRequires.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String requireType;
    private final String versionName;

    private DocumentRequires(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.requireType = builder.requireType;
        this.versionName = builder.versionName;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String requireType() {
        return this.requireType;
    }

    public final String versionName() {
        return this.versionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireType());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentRequires)) {
            return false;
        }
        DocumentRequires other = (DocumentRequires)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.requireType(), other.requireType()) && Objects.equals(this.versionName(), other.versionName());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentRequires").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("RequireType", (Object)this.requireType()).add("VersionName", (Object)this.versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "RequireType": {
                return Optional.ofNullable(clazz.cast(this.requireType()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("RequireType", REQUIRE_TYPE_FIELD);
        map.put("VersionName", VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentRequires, T> g) {
        return obj -> g.apply((DocumentRequires)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String requireType;
        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentRequires model) {
            this.name(model.name);
            this.version(model.version);
            this.requireType(model.requireType);
            this.versionName(model.versionName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRequireType() {
            return this.requireType;
        }

        public final void setRequireType(String requireType) {
            this.requireType = requireType;
        }

        @Override
        public final Builder requireType(String requireType) {
            this.requireType = requireType;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public DocumentRequires build() {
            return new DocumentRequires(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentRequires> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder requireType(String var1);

        public Builder versionName(String var1);
    }
}

