/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Resource Name (ARN) is already associated with the OpsItem.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemRelatedItemAlreadyExistsException extends SsmException implements
        ToCopyableBuilder<OpsItemRelatedItemAlreadyExistsException.Builder, OpsItemRelatedItemAlreadyExistsException> {
    private static final SdkField<String> RESOURCE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceUri").getter(getter(OpsItemRelatedItemAlreadyExistsException::resourceUri))
            .setter(setter(Builder::resourceUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceUri").build()).build();

    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(OpsItemRelatedItemAlreadyExistsException::opsItemId))
            .setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_URI_FIELD,
            OPS_ITEM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceUri;

    private final String opsItemId;

    private OpsItemRelatedItemAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.resourceUri = builder.resourceUri;
        this.opsItemId = builder.opsItemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ResourceUri property for this object.
     * 
     * @return The value of the ResourceUri property for this object.
     */
    public String resourceUri() {
        return resourceUri;
    }

    /**
     * Returns the value of the OpsItemId property for this object.
     * 
     * @return The value of the OpsItemId property for this object.
     */
    public String opsItemId() {
        return opsItemId;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceUri", RESOURCE_URI_FIELD);
        map.put("OpsItemId", OPS_ITEM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsItemRelatedItemAlreadyExistsException, T> g) {
        return obj -> g.apply((OpsItemRelatedItemAlreadyExistsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemRelatedItemAlreadyExistsException>,
            SsmException.Builder {
        /**
         * Sets the value of the ResourceUri property for this object.
         *
         * @param resourceUri
         *        The new value for the ResourceUri property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceUri(String resourceUri);

        /**
         * Sets the value of the OpsItemId property for this object.
         *
         * @param opsItemId
         *        The new value for the OpsItemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private String resourceUri;

        private String opsItemId;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemRelatedItemAlreadyExistsException model) {
            super(model);
            resourceUri(model.resourceUri);
            opsItemId(model.opsItemId);
        }

        public final String getResourceUri() {
            return resourceUri;
        }

        public final void setResourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
        }

        @Override
        public final Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            return this;
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public OpsItemRelatedItemAlreadyExistsException build() {
            return new OpsItemRelatedItemAlreadyExistsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
