/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The URL of S3 bucket where you want to store the results of this request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceAssociationOutputUrl implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceAssociationOutputUrl.Builder, InstanceAssociationOutputUrl> {
    private static final SdkField<S3OutputUrl> S3_OUTPUT_URL_FIELD = SdkField.<S3OutputUrl> builder(MarshallingType.SDK_POJO)
            .memberName("S3OutputUrl").getter(getter(InstanceAssociationOutputUrl::s3OutputUrl))
            .setter(setter(Builder::s3OutputUrl)).constructor(S3OutputUrl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3OutputUrl s3OutputUrl;

    private InstanceAssociationOutputUrl(BuilderImpl builder) {
        this.s3OutputUrl = builder.s3OutputUrl;
    }

    /**
     * <p>
     * The URL of S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return The URL of S3 bucket where you want to store the results of this request.
     */
    public final S3OutputUrl s3OutputUrl() {
        return s3OutputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationOutputUrl)) {
            return false;
        }
        InstanceAssociationOutputUrl other = (InstanceAssociationOutputUrl) obj;
        return Objects.equals(s3OutputUrl(), other.s3OutputUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceAssociationOutputUrl").add("S3OutputUrl", s3OutputUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputUrl":
            return Optional.ofNullable(clazz.cast(s3OutputUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3OutputUrl", S3_OUTPUT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceAssociationOutputUrl, T> g) {
        return obj -> g.apply((InstanceAssociationOutputUrl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceAssociationOutputUrl> {
        /**
         * <p>
         * The URL of S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param s3OutputUrl
         *        The URL of S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputUrl(S3OutputUrl s3OutputUrl);

        /**
         * <p>
         * The URL of S3 bucket where you want to store the results of this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3OutputUrl.Builder} avoiding the need to
         * create one manually via {@link S3OutputUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3OutputUrl.Builder#build()} is called immediately and its result
         * is passed to {@link #s3OutputUrl(S3OutputUrl)}.
         * 
         * @param s3OutputUrl
         *        a consumer that will call methods on {@link S3OutputUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputUrl(S3OutputUrl)
         */
        default Builder s3OutputUrl(Consumer<S3OutputUrl.Builder> s3OutputUrl) {
            return s3OutputUrl(S3OutputUrl.builder().applyMutation(s3OutputUrl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3OutputUrl s3OutputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationOutputUrl model) {
            s3OutputUrl(model.s3OutputUrl);
        }

        public final S3OutputUrl.Builder getS3OutputUrl() {
            return s3OutputUrl != null ? s3OutputUrl.toBuilder() : null;
        }

        public final void setS3OutputUrl(S3OutputUrl.BuilderImpl s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl != null ? s3OutputUrl.build() : null;
        }

        @Override
        public final Builder s3OutputUrl(S3OutputUrl s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl;
            return this;
        }

        @Override
        public InstanceAssociationOutputUrl build() {
            return new InstanceAssociationOutputUrl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
