/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OpsItemIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsItemEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsItemEventSummary> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemId").getter(OpsItemEventSummary.getter(OpsItemEventSummary::opsItemId)).setter(OpsItemEventSummary.setter(Builder::opsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(OpsItemEventSummary.getter(OpsItemEventSummary::eventId)).setter(OpsItemEventSummary.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(OpsItemEventSummary.getter(OpsItemEventSummary::source)).setter(OpsItemEventSummary.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailType").getter(OpsItemEventSummary.getter(OpsItemEventSummary::detailType)).setter(OpsItemEventSummary.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Detail").getter(OpsItemEventSummary.getter(OpsItemEventSummary::detail)).setter(OpsItemEventSummary.setter(Builder::detail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()}).build();
    private static final SdkField<OpsItemIdentity> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(OpsItemEventSummary.getter(OpsItemEventSummary::createdBy)).setter(OpsItemEventSummary.setter(Builder::createdBy)).constructor(OpsItemIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(OpsItemEventSummary.getter(OpsItemEventSummary::createdTime)).setter(OpsItemEventSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD, EVENT_ID_FIELD, SOURCE_FIELD, DETAIL_TYPE_FIELD, DETAIL_FIELD, CREATED_BY_FIELD, CREATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpsItemEventSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String opsItemId;
    private final String eventId;
    private final String source;
    private final String detailType;
    private final String detail;
    private final OpsItemIdentity createdBy;
    private final Instant createdTime;

    private OpsItemEventSummary(BuilderImpl builder) {
        this.opsItemId = builder.opsItemId;
        this.eventId = builder.eventId;
        this.source = builder.source;
        this.detailType = builder.detailType;
        this.detail = builder.detail;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
    }

    public final String opsItemId() {
        return this.opsItemId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String source() {
        return this.source;
    }

    public final String detailType() {
        return this.detailType;
    }

    public final String detail() {
        return this.detail;
    }

    public final OpsItemIdentity createdBy() {
        return this.createdBy;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemEventSummary)) {
            return false;
        }
        OpsItemEventSummary other = (OpsItemEventSummary)obj;
        return Objects.equals(this.opsItemId(), other.opsItemId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.detailType(), other.detailType()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"OpsItemEventSummary").add("OpsItemId", (Object)this.opsItemId()).add("EventId", (Object)this.eventId()).add("Source", (Object)this.source()).add("DetailType", (Object)this.detailType()).add("Detail", (Object)this.detail()).add("CreatedBy", (Object)this.createdBy()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsItemId": {
                return Optional.ofNullable(clazz.cast(this.opsItemId()));
            }
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailType()));
            }
            case "Detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OpsItemId", OPS_ITEM_ID_FIELD);
        map.put("EventId", EVENT_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        map.put("Detail", DETAIL_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsItemEventSummary, T> g) {
        return obj -> g.apply((OpsItemEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String opsItemId;
        private String eventId;
        private String source;
        private String detailType;
        private String detail;
        private OpsItemIdentity createdBy;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemEventSummary model) {
            this.opsItemId(model.opsItemId);
            this.eventId(model.eventId);
            this.source(model.source);
            this.detailType(model.detailType);
            this.detail(model.detail);
            this.createdBy(model.createdBy);
            this.createdTime(model.createdTime);
        }

        public final String getOpsItemId() {
            return this.opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDetailType() {
            return this.detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final String getDetail() {
            return this.detail;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final OpsItemIdentity.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(OpsItemIdentity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(OpsItemIdentity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public OpsItemEventSummary build() {
            return new OpsItemEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsItemEventSummary> {
        public Builder opsItemId(String var1);

        public Builder eventId(String var1);

        public Builder source(String var1);

        public Builder detailType(String var1);

        public Builder detail(String var1);

        public Builder createdBy(OpsItemIdentity var1);

        default public Builder createdBy(Consumer<OpsItemIdentity.Builder> createdBy) {
            return this.createdBy((OpsItemIdentity)((OpsItemIdentity.Builder)OpsItemIdentity.builder().applyMutation(createdBy)).build());
        }

        public Builder createdTime(Instant var1);
    }
}

