/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of resources that aren't compliant. The summary is organized according to resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NonCompliantSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NonCompliantSummary.Builder, NonCompliantSummary> {
    private static final SdkField<Integer> NON_COMPLIANT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NonCompliantCount").getter(getter(NonCompliantSummary::nonCompliantCount))
            .setter(setter(Builder::nonCompliantCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantCount").build()).build();

    private static final SdkField<SeveritySummary> SEVERITY_SUMMARY_FIELD = SdkField
            .<SeveritySummary> builder(MarshallingType.SDK_POJO).memberName("SeveritySummary")
            .getter(getter(NonCompliantSummary::severitySummary)).setter(setter(Builder::severitySummary))
            .constructor(SeveritySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeveritySummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_COMPLIANT_COUNT_FIELD,
            SEVERITY_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer nonCompliantCount;

    private final SeveritySummary severitySummary;

    private NonCompliantSummary(BuilderImpl builder) {
        this.nonCompliantCount = builder.nonCompliantCount;
        this.severitySummary = builder.severitySummary;
    }

    /**
     * <p>
     * The total number of compliance items that aren't compliant.
     * </p>
     * 
     * @return The total number of compliance items that aren't compliant.
     */
    public final Integer nonCompliantCount() {
        return nonCompliantCount;
    }

    /**
     * <p>
     * A summary of the non-compliance severity by compliance type
     * </p>
     * 
     * @return A summary of the non-compliance severity by compliance type
     */
    public final SeveritySummary severitySummary() {
        return severitySummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(severitySummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NonCompliantSummary)) {
            return false;
        }
        NonCompliantSummary other = (NonCompliantSummary) obj;
        return Objects.equals(nonCompliantCount(), other.nonCompliantCount())
                && Objects.equals(severitySummary(), other.severitySummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NonCompliantSummary").add("NonCompliantCount", nonCompliantCount())
                .add("SeveritySummary", severitySummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonCompliantCount":
            return Optional.ofNullable(clazz.cast(nonCompliantCount()));
        case "SeveritySummary":
            return Optional.ofNullable(clazz.cast(severitySummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NonCompliantCount", NON_COMPLIANT_COUNT_FIELD);
        map.put("SeveritySummary", SEVERITY_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NonCompliantSummary, T> g) {
        return obj -> g.apply((NonCompliantSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NonCompliantSummary> {
        /**
         * <p>
         * The total number of compliance items that aren't compliant.
         * </p>
         * 
         * @param nonCompliantCount
         *        The total number of compliance items that aren't compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantCount(Integer nonCompliantCount);

        /**
         * <p>
         * A summary of the non-compliance severity by compliance type
         * </p>
         * 
         * @param severitySummary
         *        A summary of the non-compliance severity by compliance type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitySummary(SeveritySummary severitySummary);

        /**
         * <p>
         * A summary of the non-compliance severity by compliance type
         * </p>
         * This is a convenience method that creates an instance of the {@link SeveritySummary.Builder} avoiding the
         * need to create one manually via {@link SeveritySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeveritySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #severitySummary(SeveritySummary)}.
         * 
         * @param severitySummary
         *        a consumer that will call methods on {@link SeveritySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severitySummary(SeveritySummary)
         */
        default Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return severitySummary(SeveritySummary.builder().applyMutation(severitySummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer nonCompliantCount;

        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NonCompliantSummary model) {
            nonCompliantCount(model.nonCompliantCount);
            severitySummary(model.severitySummary);
        }

        public final Integer getNonCompliantCount() {
            return nonCompliantCount;
        }

        public final void setNonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
        }

        @Override
        public final Builder nonCompliantCount(Integer nonCompliantCount) {
            this.nonCompliantCount = nonCompliantCount;
            return this;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return severitySummary != null ? severitySummary.toBuilder() : null;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        @Override
        public NonCompliantSummary build() {
            return new NonCompliantSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
