/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExecutionPreviewResponse extends SsmResponse implements
        ToCopyableBuilder<GetExecutionPreviewResponse.Builder, GetExecutionPreviewResponse> {
    private static final SdkField<String> EXECUTION_PREVIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionPreviewId").getter(getter(GetExecutionPreviewResponse::executionPreviewId))
            .setter(setter(Builder::executionPreviewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionPreviewId").build())
            .build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt").getter(getter(GetExecutionPreviewResponse::endedAt)).setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetExecutionPreviewResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetExecutionPreviewResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<ExecutionPreview> EXECUTION_PREVIEW_FIELD = SdkField
            .<ExecutionPreview> builder(MarshallingType.SDK_POJO).memberName("ExecutionPreview")
            .getter(getter(GetExecutionPreviewResponse::executionPreview)).setter(setter(Builder::executionPreview))
            .constructor(ExecutionPreview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionPreview").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_PREVIEW_ID_FIELD,
            ENDED_AT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, EXECUTION_PREVIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionPreviewId;

    private final Instant endedAt;

    private final String status;

    private final String statusMessage;

    private final ExecutionPreview executionPreview;

    private GetExecutionPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.executionPreviewId = builder.executionPreviewId;
        this.endedAt = builder.endedAt;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.executionPreview = builder.executionPreview;
    }

    /**
     * <p>
     * The generated ID for the existing execution preview.
     * </p>
     * 
     * @return The generated ID for the existing execution preview.
     */
    public final String executionPreviewId() {
        return executionPreviewId;
    }

    /**
     * <p>
     * A UTC timestamp indicating when the execution preview operation ended.
     * </p>
     * 
     * @return A UTC timestamp indicating when the execution preview operation ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The current status of the execution preview operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution preview operation.
     * @see ExecutionPreviewStatus
     */
    public final ExecutionPreviewStatus status() {
        return ExecutionPreviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the execution preview operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution preview operation.
     * @see ExecutionPreviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Supplemental information about the current status of the execution preview.
     * </p>
     * 
     * @return Supplemental information about the current status of the execution preview.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * Returns the value of the ExecutionPreview property for this object.
     * 
     * @return The value of the ExecutionPreview property for this object.
     */
    public final ExecutionPreview executionPreview() {
        return executionPreview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionPreviewId());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(executionPreview());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExecutionPreviewResponse)) {
            return false;
        }
        GetExecutionPreviewResponse other = (GetExecutionPreviewResponse) obj;
        return Objects.equals(executionPreviewId(), other.executionPreviewId()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(executionPreview(), other.executionPreview());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExecutionPreviewResponse").add("ExecutionPreviewId", executionPreviewId())
                .add("EndedAt", endedAt()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ExecutionPreview", executionPreview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionPreviewId":
            return Optional.ofNullable(clazz.cast(executionPreviewId()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ExecutionPreview":
            return Optional.ofNullable(clazz.cast(executionPreview()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionPreviewId", EXECUTION_PREVIEW_ID_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ExecutionPreview", EXECUTION_PREVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetExecutionPreviewResponse, T> g) {
        return obj -> g.apply((GetExecutionPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExecutionPreviewResponse> {
        /**
         * <p>
         * The generated ID for the existing execution preview.
         * </p>
         * 
         * @param executionPreviewId
         *        The generated ID for the existing execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionPreviewId(String executionPreviewId);

        /**
         * <p>
         * A UTC timestamp indicating when the execution preview operation ended.
         * </p>
         * 
         * @param endedAt
         *        A UTC timestamp indicating when the execution preview operation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The current status of the execution preview operation.
         * </p>
         * 
         * @param status
         *        The current status of the execution preview operation.
         * @see ExecutionPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionPreviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the execution preview operation.
         * </p>
         * 
         * @param status
         *        The current status of the execution preview operation.
         * @see ExecutionPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionPreviewStatus
         */
        Builder status(ExecutionPreviewStatus status);

        /**
         * <p>
         * Supplemental information about the current status of the execution preview.
         * </p>
         * 
         * @param statusMessage
         *        Supplemental information about the current status of the execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * Sets the value of the ExecutionPreview property for this object.
         *
         * @param executionPreview
         *        The new value for the ExecutionPreview property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionPreview(ExecutionPreview executionPreview);

        /**
         * Sets the value of the ExecutionPreview property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExecutionPreview.Builder} avoiding the
         * need to create one manually via {@link ExecutionPreview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionPreview.Builder#build()} is called immediately and its
         * result is passed to {@link #executionPreview(ExecutionPreview)}.
         * 
         * @param executionPreview
         *        a consumer that will call methods on {@link ExecutionPreview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionPreview(ExecutionPreview)
         */
        default Builder executionPreview(Consumer<ExecutionPreview.Builder> executionPreview) {
            return executionPreview(ExecutionPreview.builder().applyMutation(executionPreview).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String executionPreviewId;

        private Instant endedAt;

        private String status;

        private String statusMessage;

        private ExecutionPreview executionPreview;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExecutionPreviewResponse model) {
            super(model);
            executionPreviewId(model.executionPreviewId);
            endedAt(model.endedAt);
            status(model.status);
            statusMessage(model.statusMessage);
            executionPreview(model.executionPreview);
        }

        public final String getExecutionPreviewId() {
            return executionPreviewId;
        }

        public final void setExecutionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
        }

        @Override
        public final Builder executionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ExecutionPreview.Builder getExecutionPreview() {
            return executionPreview != null ? executionPreview.toBuilder() : null;
        }

        public final void setExecutionPreview(ExecutionPreview.BuilderImpl executionPreview) {
            this.executionPreview = executionPreview != null ? executionPreview.build() : null;
        }

        @Override
        public final Builder executionPreview(ExecutionPreview executionPreview) {
            this.executionPreview = executionPreview;
            return this;
        }

        @Override
        public GetExecutionPreviewResponse build() {
            return new GetExecutionPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
