/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentFilter;
import software.amazon.awssdk.services.ssm.model.DocumentFilterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilter;
import software.amazon.awssdk.services.ssm.model.DocumentKeyValuesFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, ListDocumentsRequest> {
    private static final SdkField<List<DocumentFilter>> DOCUMENT_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentFilterList").getter(ListDocumentsRequest.getter(ListDocumentsRequest::documentFilterList)).setter(ListDocumentsRequest.setter(Builder::documentFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentKeyValuesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListDocumentsRequest.getter(ListDocumentsRequest::filters)).setter(ListDocumentsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentKeyValuesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDocumentsRequest.getter(ListDocumentsRequest::maxResults)).setter(ListDocumentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentsRequest.getter(ListDocumentsRequest::nextToken)).setter(ListDocumentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FILTER_LIST_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentFilterList", DOCUMENT_FILTER_LIST_FIELD);
            this.put("Filters", FILTERS_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DocumentFilter> documentFilterList;
    private final List<DocumentKeyValuesFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.documentFilterList = builder.documentFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDocumentFilterList() {
        return this.documentFilterList != null && !(this.documentFilterList instanceof SdkAutoConstructList);
    }

    public final List<DocumentFilter> documentFilterList() {
        return this.documentFilterList;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<DocumentKeyValuesFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentFilterList() ? this.documentFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)((Object)obj);
        return this.hasDocumentFilterList() == other.hasDocumentFilterList() && Objects.equals(this.documentFilterList(), other.documentFilterList()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentsRequest").add("DocumentFilterList", this.hasDocumentFilterList() ? this.documentFilterList() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentFilterList": {
                return Optional.ofNullable(clazz.cast(this.documentFilterList()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentsRequest, T> g) {
        return obj -> g.apply((ListDocumentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<DocumentFilter> documentFilterList = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentKeyValuesFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsRequest model) {
            super(model);
            this.documentFilterList(model.documentFilterList);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<DocumentFilter.Builder> getDocumentFilterList() {
            List<DocumentFilter.Builder> result = DocumentFilterListCopier.copyToBuilder(this.documentFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentFilterList(Collection<DocumentFilter.BuilderImpl> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copyFromBuilder(documentFilterList);
        }

        @Override
        public final Builder documentFilterList(Collection<DocumentFilter> documentFilterList) {
            this.documentFilterList = DocumentFilterListCopier.copy(documentFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(DocumentFilter ... documentFilterList) {
            this.documentFilterList(Arrays.asList(documentFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentFilterList(Consumer<DocumentFilter.Builder> ... documentFilterList) {
            this.documentFilterList(Stream.of(documentFilterList).map(c -> (DocumentFilter)((DocumentFilter.Builder)DocumentFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentKeyValuesFilter.Builder> getFilters() {
            List<DocumentKeyValuesFilter.Builder> result = DocumentKeyValuesFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DocumentKeyValuesFilter.BuilderImpl> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DocumentKeyValuesFilter> filters) {
            this.filters = DocumentKeyValuesFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DocumentKeyValuesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DocumentKeyValuesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DocumentKeyValuesFilter)((DocumentKeyValuesFilter.Builder)DocumentKeyValuesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDocumentsRequest build() {
            return new ListDocumentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentsRequest> {
        public Builder documentFilterList(Collection<DocumentFilter> var1);

        public Builder documentFilterList(DocumentFilter ... var1);

        public Builder documentFilterList(Consumer<DocumentFilter.Builder> ... var1);

        public Builder filters(Collection<DocumentKeyValuesFilter> var1);

        public Builder filters(DocumentKeyValuesFilter ... var1);

        public Builder filters(Consumer<DocumentKeyValuesFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

