/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentityListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowExecutionTasksResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private static final SdkField<List<MaintenanceWindowExecutionTaskIdentity>> WINDOW_EXECUTION_TASK_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WindowExecutionTaskIdentities").getter(DescribeMaintenanceWindowExecutionTasksResponse.getter(DescribeMaintenanceWindowExecutionTasksResponse::windowExecutionTaskIdentities)).setter(DescribeMaintenanceWindowExecutionTasksResponse.setter(Builder::windowExecutionTaskIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionTaskIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowExecutionTaskIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMaintenanceWindowExecutionTasksResponse.getter(DescribeMaintenanceWindowExecutionTasksResponse::nextToken)).setter(DescribeMaintenanceWindowExecutionTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_TASK_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WindowExecutionTaskIdentities", WINDOW_EXECUTION_TASK_IDENTITIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWindowExecutionTaskIdentities() {
        return this.windowExecutionTaskIdentities != null && !(this.windowExecutionTaskIdentities instanceof SdkAutoConstructList);
    }

    public final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return this.windowExecutionTaskIdentities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWindowExecutionTaskIdentities() ? this.windowExecutionTaskIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse)((Object)obj);
        return this.hasWindowExecutionTaskIdentities() == other.hasWindowExecutionTaskIdentities() && Objects.equals(this.windowExecutionTaskIdentities(), other.windowExecutionTaskIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowExecutionTasksResponse").add("WindowExecutionTaskIdentities", this.hasWindowExecutionTaskIdentities() ? this.windowExecutionTaskIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionTaskIdentities": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionTaskIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionTasksResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            super(model);
            this.windowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            this.nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowExecutionTaskIdentity.Builder> getWindowExecutionTaskIdentities() {
            List<MaintenanceWindowExecutionTaskIdentity.Builder> result = MaintenanceWindowExecutionTaskIdentityListCopier.copyToBuilder(this.windowExecutionTaskIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWindowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity.BuilderImpl> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copyFromBuilder(windowExecutionTaskIdentities);
        }

        @Override
        public final Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities(Arrays.asList(windowExecutionTaskIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(Consumer<MaintenanceWindowExecutionTaskIdentity.Builder> ... windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities(Stream.of(windowExecutionTaskIdentities).map(c -> (MaintenanceWindowExecutionTaskIdentity)((MaintenanceWindowExecutionTaskIdentity.Builder)MaintenanceWindowExecutionTaskIdentity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        public Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> var1);

        public Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... var1);

        public Builder windowExecutionTaskIdentities(Consumer<MaintenanceWindowExecutionTaskIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

