/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.AttachmentHashType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachmentContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttachmentContent> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AttachmentContent.getter(AttachmentContent::name)).setter(AttachmentContent.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(AttachmentContent.getter(AttachmentContent::size)).setter(AttachmentContent.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(AttachmentContent.getter(AttachmentContent::hash)).setter(AttachmentContent.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()}).build();
    private static final SdkField<String> HASH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HashType").getter(AttachmentContent.getter(AttachmentContent::hashTypeAsString)).setter(AttachmentContent.setter(Builder::hashType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashType").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(AttachmentContent.getter(AttachmentContent::url)).setter(AttachmentContent.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SIZE_FIELD, HASH_FIELD, HASH_TYPE_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Size", SIZE_FIELD);
            this.put("Hash", HASH_FIELD);
            this.put("HashType", HASH_TYPE_FIELD);
            this.put("Url", URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Long size;
    private final String hash;
    private final String hashType;
    private final String url;

    private AttachmentContent(BuilderImpl builder) {
        this.name = builder.name;
        this.size = builder.size;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.url = builder.url;
    }

    public final String name() {
        return this.name;
    }

    public final Long size() {
        return this.size;
    }

    public final String hash() {
        return this.hash;
    }

    public final AttachmentHashType hashType() {
        return AttachmentHashType.fromValue(this.hashType);
    }

    public final String hashTypeAsString() {
        return this.hashType;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentContent)) {
            return false;
        }
        AttachmentContent other = (AttachmentContent)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.hashTypeAsString(), other.hashTypeAsString()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"AttachmentContent").add("Name", (Object)this.name()).add("Size", (Object)this.size()).add("Hash", (Object)this.hash()).add("HashType", (Object)this.hashTypeAsString()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "HashType": {
                return Optional.ofNullable(clazz.cast(this.hashTypeAsString()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentContent, T> g) {
        return obj -> g.apply((AttachmentContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Long size;
        private String hash;
        private String hashType;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentContent model) {
            this.name(model.name);
            this.size(model.size);
            this.hash(model.hash);
            this.hashType(model.hashType);
            this.url(model.url);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final String getHashType() {
            return this.hashType;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(AttachmentHashType hashType) {
            this.hashType(hashType == null ? null : hashType.toString());
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public AttachmentContent build() {
            return new AttachmentContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttachmentContent> {
        public Builder name(String var1);

        public Builder size(Long var1);

        public Builder hash(String var1);

        public Builder hashType(String var1);

        public Builder hashType(AttachmentHashType var1);

        public Builder url(String var1);
    }
}

