/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMaintenanceWindowTargetRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateMaintenanceWindowTargetRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::windowId)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowTargetId").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::windowTargetId)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::windowTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::targets)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerInformation").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::ownerInformation)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::ownerInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::name)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::description)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Replace").getter(UpdateMaintenanceWindowTargetRequest.getter(UpdateMaintenanceWindowTargetRequest::replace)).setter(UpdateMaintenanceWindowTargetRequest.setter(Builder::replace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, WINDOW_TARGET_ID_FIELD, TARGETS_FIELD, OWNER_INFORMATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, REPLACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WindowId", WINDOW_ID_FIELD);
            this.put("WindowTargetId", WINDOW_TARGET_ID_FIELD);
            this.put("Targets", TARGETS_FIELD);
            this.put("OwnerInformation", OWNER_INFORMATION_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Replace", REPLACE_FIELD);
        }
    });
    private final String windowId;
    private final String windowTargetId;
    private final List<Target> targets;
    private final String ownerInformation;
    private final String name;
    private final String description;
    private final Boolean replace;

    private UpdateMaintenanceWindowTargetRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
        this.replace = builder.replace;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final String windowTargetId() {
        return this.windowTargetId;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final String ownerInformation() {
        return this.ownerInformation;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean replace() {
        return this.replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.replace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTargetRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTargetRequest other = (UpdateMaintenanceWindowTargetRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTargetId(), other.windowTargetId()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.replace(), other.replace());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMaintenanceWindowTargetRequest").add("WindowId", (Object)this.windowId()).add("WindowTargetId", (Object)this.windowTargetId()).add("Targets", this.hasTargets() ? this.targets() : null).add("OwnerInformation", (Object)(this.ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Replace", (Object)this.replace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowTargetId": {
                return Optional.ofNullable(clazz.cast(this.windowTargetId()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Replace": {
                return Optional.ofNullable(clazz.cast(this.replace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceWindowTargetRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceWindowTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTargetId;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String ownerInformation;
        private String name;
        private String description;
        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTargetRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.windowTargetId(model.windowTargetId);
            this.targets(model.targets);
            this.ownerInformation(model.ownerInformation);
            this.name(model.name);
            this.description(model.description);
            this.replace(model.replace);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getReplace() {
            return this.replace;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowTargetRequest build() {
            return new UpdateMaintenanceWindowTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMaintenanceWindowTargetRequest> {
        public Builder windowId(String var1);

        public Builder windowTargetId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder ownerInformation(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder replace(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

