/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.AssociationExecution;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;

public class DescribeAssociationExecutionsIterable
implements SdkIterable<DescribeAssociationExecutionsResponse> {
    private final SsmClient client;
    private final DescribeAssociationExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAssociationExecutionsIterable(SsmClient client, DescribeAssociationExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAssociationExecutionsResponseFetcher();
    }

    public Iterator<DescribeAssociationExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociationExecution> associationExecutions() {
        Function<DescribeAssociationExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associationExecutions() != null) {
                return response.associationExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAssociationExecutionsResponseFetcher
    implements SyncPageFetcher<DescribeAssociationExecutionsResponse> {
        private DescribeAssociationExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAssociationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAssociationExecutionsResponse nextPage(DescribeAssociationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAssociationExecutionsIterable.this.client.describeAssociationExecutions(DescribeAssociationExecutionsIterable.this.firstRequest);
            }
            return DescribeAssociationExecutionsIterable.this.client.describeAssociationExecutions((DescribeAssociationExecutionsRequest)((Object)DescribeAssociationExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

