/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMaintenanceWindowExecutionTaskInvocationRequest extends SsmRequest
        implements
        ToCopyableBuilder<GetMaintenanceWindowExecutionTaskInvocationRequest.Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowExecutionId")
            .getter(getter(GetMaintenanceWindowExecutionTaskInvocationRequest::windowExecutionId))
            .setter(setter(Builder::windowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TaskId")
            .getter(getter(GetMaintenanceWindowExecutionTaskInvocationRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationId").getter(getter(GetMaintenanceWindowExecutionTaskInvocationRequest::invocationId))
            .setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD,
            TASK_ID_FIELD, INVOCATION_ID_FIELD));

    private final String windowExecutionId;

    private final String taskId;

    private final String invocationId;

    private GetMaintenanceWindowExecutionTaskInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
        this.invocationId = builder.invocationId;
    }

    /**
     * <p>
     * The ID of the maintenance window execution for which the task is a part.
     * </p>
     * 
     * @return The ID of the maintenance window execution for which the task is a part.
     */
    public final String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task in the maintenance window task that should be retrieved.
     * </p>
     * 
     * @return The ID of the specific task in the maintenance window task that should be retrieved.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The invocation ID to retrieve.
     * </p>
     * 
     * @return The invocation ID to retrieve.
     */
    public final String invocationId() {
        return invocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskInvocationRequest)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskInvocationRequest other = (GetMaintenanceWindowExecutionTaskInvocationRequest) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(invocationId(), other.invocationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMaintenanceWindowExecutionTaskInvocationRequest")
                .add("WindowExecutionId", windowExecutionId()).add("TaskId", taskId()).add("InvocationId", invocationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.ofNullable(clazz.cast(windowExecutionId()));
        case "TaskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "InvocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMaintenanceWindowExecutionTaskInvocationRequest, T> g) {
        return obj -> g.apply((GetMaintenanceWindowExecutionTaskInvocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskInvocationRequest> {
        /**
         * <p>
         * The ID of the maintenance window execution for which the task is a part.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the maintenance window execution for which the task is a part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task in the maintenance window task that should be retrieved.
         * </p>
         * 
         * @param taskId
         *        The ID of the specific task in the maintenance window task that should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The invocation ID to retrieve.
         * </p>
         * 
         * @param invocationId
         *        The invocation ID to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskId;

        private String invocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskInvocationRequest model) {
            super(model);
            windowExecutionId(model.windowExecutionId);
            taskId(model.taskId);
            invocationId(model.invocationId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskInvocationRequest build() {
            return new GetMaintenanceWindowExecutionTaskInvocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
