/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AccountIdListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDocumentPermissionRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ModifyDocumentPermissionRequest.getter(ModifyDocumentPermissionRequest::name)).setter(ModifyDocumentPermissionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(ModifyDocumentPermissionRequest.getter(ModifyDocumentPermissionRequest::permissionTypeAsString)).setter(ModifyDocumentPermissionRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIdsToAdd").getter(ModifyDocumentPermissionRequest.getter(ModifyDocumentPermissionRequest::accountIdsToAdd)).setter(ModifyDocumentPermissionRequest.setter(Builder::accountIdsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIdsToRemove").getter(ModifyDocumentPermissionRequest.getter(ModifyDocumentPermissionRequest::accountIdsToRemove)).setter(ModifyDocumentPermissionRequest.setter(Builder::accountIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SHARED_DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedDocumentVersion").getter(ModifyDocumentPermissionRequest.getter(ModifyDocumentPermissionRequest::sharedDocumentVersion)).setter(ModifyDocumentPermissionRequest.setter(Builder::sharedDocumentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDocumentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PERMISSION_TYPE_FIELD, ACCOUNT_IDS_TO_ADD_FIELD, ACCOUNT_IDS_TO_REMOVE_FIELD, SHARED_DOCUMENT_VERSION_FIELD));
    private final String name;
    private final String permissionType;
    private final List<String> accountIdsToAdd;
    private final List<String> accountIdsToRemove;
    private final String sharedDocumentVersion;

    private ModifyDocumentPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionType = builder.permissionType;
        this.accountIdsToAdd = builder.accountIdsToAdd;
        this.accountIdsToRemove = builder.accountIdsToRemove;
        this.sharedDocumentVersion = builder.sharedDocumentVersion;
    }

    public final String name() {
        return this.name;
    }

    public final DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final boolean hasAccountIdsToAdd() {
        return this.accountIdsToAdd != null && !(this.accountIdsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdsToAdd() {
        return this.accountIdsToAdd;
    }

    public final boolean hasAccountIdsToRemove() {
        return this.accountIdsToRemove != null && !(this.accountIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdsToRemove() {
        return this.accountIdsToRemove;
    }

    public final String sharedDocumentVersion() {
        return this.sharedDocumentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdsToAdd() ? this.accountIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdsToRemove() ? this.accountIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedDocumentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDocumentPermissionRequest)) {
            return false;
        }
        ModifyDocumentPermissionRequest other = (ModifyDocumentPermissionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && this.hasAccountIdsToAdd() == other.hasAccountIdsToAdd() && Objects.equals(this.accountIdsToAdd(), other.accountIdsToAdd()) && this.hasAccountIdsToRemove() == other.hasAccountIdsToRemove() && Objects.equals(this.accountIdsToRemove(), other.accountIdsToRemove()) && Objects.equals(this.sharedDocumentVersion(), other.sharedDocumentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDocumentPermissionRequest").add("Name", (Object)this.name()).add("PermissionType", (Object)this.permissionTypeAsString()).add("AccountIdsToAdd", this.hasAccountIdsToAdd() ? this.accountIdsToAdd() : null).add("AccountIdsToRemove", this.hasAccountIdsToRemove() ? this.accountIdsToRemove() : null).add("SharedDocumentVersion", (Object)this.sharedDocumentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "AccountIdsToAdd": {
                return Optional.ofNullable(clazz.cast(this.accountIdsToAdd()));
            }
            case "AccountIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.accountIdsToRemove()));
            }
            case "SharedDocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.sharedDocumentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDocumentPermissionRequest, T> g) {
        return obj -> g.apply((ModifyDocumentPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String permissionType;
        private List<String> accountIdsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private String sharedDocumentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDocumentPermissionRequest model) {
            super(model);
            this.name(model.name);
            this.permissionType(model.permissionType);
            this.accountIdsToAdd(model.accountIdsToAdd);
            this.accountIdsToRemove(model.accountIdsToRemove);
            this.sharedDocumentVersion(model.sharedDocumentVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final Collection<String> getAccountIdsToAdd() {
            if (this.accountIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdsToAdd;
        }

        public final void setAccountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
        }

        @Override
        public final Builder accountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToAdd(String ... accountIdsToAdd) {
            this.accountIdsToAdd(Arrays.asList(accountIdsToAdd));
            return this;
        }

        public final Collection<String> getAccountIdsToRemove() {
            if (this.accountIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdsToRemove;
        }

        public final void setAccountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
        }

        @Override
        public final Builder accountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdsToRemove(String ... accountIdsToRemove) {
            this.accountIdsToRemove(Arrays.asList(accountIdsToRemove));
            return this;
        }

        public final String getSharedDocumentVersion() {
            return this.sharedDocumentVersion;
        }

        public final void setSharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
        }

        @Override
        public final Builder sharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDocumentPermissionRequest build() {
            return new ModifyDocumentPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
        public Builder name(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(DocumentPermissionType var1);

        public Builder accountIdsToAdd(Collection<String> var1);

        public Builder accountIdsToAdd(String ... var1);

        public Builder accountIdsToRemove(Collection<String> var1);

        public Builder accountIdsToRemove(String ... var1);

        public Builder sharedDocumentVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

