/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowRunCommandParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowRunCommandParameters> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::comment)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::cloudWatchOutputConfig)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::cloudWatchOutputConfig)).constructor(CloudWatchOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build()}).build();
    private static final SdkField<String> DOCUMENT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentHash").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::documentHash)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::documentHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentHash").build()}).build();
    private static final SdkField<String> DOCUMENT_HASH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentHashType").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::documentHashTypeAsString)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::documentHashType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentHashType").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::documentVersion)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<NotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfig").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::notificationConfig)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::notificationConfig)).constructor(NotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3BucketName").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::outputS3BucketName)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3KeyPrefix").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::outputS3KeyPrefix)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::parameters)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::serviceRoleArn)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutSeconds").getter(MaintenanceWindowRunCommandParameters.getter(MaintenanceWindowRunCommandParameters::timeoutSeconds)).setter(MaintenanceWindowRunCommandParameters.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD, DOCUMENT_HASH_FIELD, DOCUMENT_HASH_TYPE_FIELD, DOCUMENT_VERSION_FIELD, NOTIFICATION_CONFIG_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, PARAMETERS_FIELD, SERVICE_ROLE_ARN_FIELD, TIMEOUT_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final CloudWatchOutputConfig cloudWatchOutputConfig;
    private final String documentHash;
    private final String documentHashType;
    private final String documentVersion;
    private final NotificationConfig notificationConfig;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final Map<String, List<String>> parameters;
    private final String serviceRoleArn;
    private final Integer timeoutSeconds;

    private MaintenanceWindowRunCommandParameters(BuilderImpl builder) {
        this.comment = builder.comment;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.documentVersion = builder.documentVersion;
        this.notificationConfig = builder.notificationConfig;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.parameters = builder.parameters;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public final String comment() {
        return this.comment;
    }

    public final CloudWatchOutputConfig cloudWatchOutputConfig() {
        return this.cloudWatchOutputConfig;
    }

    public final String documentHash() {
        return this.documentHash;
    }

    public final DocumentHashType documentHashType() {
        return DocumentHashType.fromValue(this.documentHashType);
    }

    public final String documentHashTypeAsString() {
        return this.documentHashType;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public final String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public final String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowRunCommandParameters)) {
            return false;
        }
        MaintenanceWindowRunCommandParameters other = (MaintenanceWindowRunCommandParameters)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.cloudWatchOutputConfig(), other.cloudWatchOutputConfig()) && Objects.equals(this.documentHash(), other.documentHash()) && Objects.equals(this.documentHashTypeAsString(), other.documentHashTypeAsString()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowRunCommandParameters").add("Comment", (Object)this.comment()).add("CloudWatchOutputConfig", (Object)this.cloudWatchOutputConfig()).add("DocumentHash", (Object)this.documentHash()).add("DocumentHashType", (Object)this.documentHashTypeAsString()).add("DocumentVersion", (Object)this.documentVersion()).add("NotificationConfig", (Object)this.notificationConfig()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "CloudWatchOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputConfig()));
            }
            case "DocumentHash": {
                return Optional.ofNullable(clazz.cast(this.documentHash()));
            }
            case "DocumentHashType": {
                return Optional.ofNullable(clazz.cast(this.documentHashTypeAsString()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "TimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowRunCommandParameters, T> g) {
        return obj -> g.apply((MaintenanceWindowRunCommandParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private CloudWatchOutputConfig cloudWatchOutputConfig;
        private String documentHash;
        private String documentHashType;
        private String documentVersion;
        private NotificationConfig notificationConfig;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String serviceRoleArn;
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowRunCommandParameters model) {
            this.comment(model.comment);
            this.cloudWatchOutputConfig(model.cloudWatchOutputConfig);
            this.documentHash(model.documentHash);
            this.documentHashType(model.documentHashType);
            this.documentVersion(model.documentVersion);
            this.notificationConfig(model.notificationConfig);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.parameters(model.parameters);
            this.serviceRoleArn(model.serviceRoleArn);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.toBuilder() : null;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        @Override
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final String getDocumentHash() {
            return this.documentHash;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final String getDocumentHashType() {
            return this.documentHashType;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType == null ? null : documentHashType.toString());
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public MaintenanceWindowRunCommandParameters build() {
            return new MaintenanceWindowRunCommandParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowRunCommandParameters> {
        public Builder comment(String var1);

        public Builder cloudWatchOutputConfig(CloudWatchOutputConfig var1);

        default public Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return this.cloudWatchOutputConfig((CloudWatchOutputConfig)((CloudWatchOutputConfig.Builder)CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig)).build());
        }

        public Builder documentHash(String var1);

        public Builder documentHashType(String var1);

        public Builder documentHashType(DocumentHashType var1);

        public Builder documentVersion(String var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().applyMutation(notificationConfig)).build());
        }

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder serviceRoleArn(String var1);

        public Builder timeoutSeconds(Integer var1);
    }
}

