/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class OpsMetadataListCopier {
    static List<OpsMetadata> copy(Collection<? extends OpsMetadata> opsMetadataListParam) {
        List<OpsMetadata> list;
        if (opsMetadataListParam == null || opsMetadataListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OpsMetadata> modifiableList = new ArrayList<>();
            opsMetadataListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OpsMetadata> copyFromBuilder(Collection<? extends OpsMetadata.Builder> opsMetadataListParam) {
        List<OpsMetadata> list;
        if (opsMetadataListParam == null || opsMetadataListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OpsMetadata> modifiableList = new ArrayList<>();
            opsMetadataListParam.forEach(entry -> {
                OpsMetadata member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OpsMetadata.Builder> copyToBuilder(Collection<? extends OpsMetadata> opsMetadataListParam) {
        List<OpsMetadata.Builder> list;
        if (opsMetadataListParam == null || opsMetadataListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OpsMetadata.Builder> modifiableList = new ArrayList<>();
            opsMetadataListParam.forEach(entry -> {
                OpsMetadata.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
