/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.Runbook;
import software.amazon.awssdk.services.ssm.model.RunbooksCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChangeRequestExecutionRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, StartChangeRequestExecutionRequest> {
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::scheduledTime)).setter(StartChangeRequestExecutionRequest.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::documentName)).setter(StartChangeRequestExecutionRequest.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::documentVersion)).setter(StartChangeRequestExecutionRequest.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::parameters)).setter(StartChangeRequestExecutionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_REQUEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeRequestName").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::changeRequestName)).setter(StartChangeRequestExecutionRequest.setter(Builder::changeRequestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeRequestName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::clientToken)).setter(StartChangeRequestExecutionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Boolean> AUTO_APPROVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoApprove").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::autoApprove)).setter(StartChangeRequestExecutionRequest.setter(Builder::autoApprove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoApprove").build()}).build();
    private static final SdkField<List<Runbook>> RUNBOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Runbooks").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::runbooks)).setter(StartChangeRequestExecutionRequest.setter(Builder::runbooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runbooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Runbook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::tags)).setter(StartChangeRequestExecutionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> SCHEDULED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledEndTime").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::scheduledEndTime)).setter(StartChangeRequestExecutionRequest.setter(Builder::scheduledEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledEndTime").build()}).build();
    private static final SdkField<String> CHANGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeDetails").getter(StartChangeRequestExecutionRequest.getter(StartChangeRequestExecutionRequest::changeDetails)).setter(StartChangeRequestExecutionRequest.setter(Builder::changeDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_TIME_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, CHANGE_REQUEST_NAME_FIELD, CLIENT_TOKEN_FIELD, AUTO_APPROVE_FIELD, RUNBOOKS_FIELD, TAGS_FIELD, SCHEDULED_END_TIME_FIELD, CHANGE_DETAILS_FIELD));
    private final Instant scheduledTime;
    private final String documentName;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final String changeRequestName;
    private final String clientToken;
    private final Boolean autoApprove;
    private final List<Runbook> runbooks;
    private final List<Tag> tags;
    private final Instant scheduledEndTime;
    private final String changeDetails;

    private StartChangeRequestExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledTime = builder.scheduledTime;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.changeRequestName = builder.changeRequestName;
        this.clientToken = builder.clientToken;
        this.autoApprove = builder.autoApprove;
        this.runbooks = builder.runbooks;
        this.tags = builder.tags;
        this.scheduledEndTime = builder.scheduledEndTime;
        this.changeDetails = builder.changeDetails;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String changeRequestName() {
        return this.changeRequestName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean autoApprove() {
        return this.autoApprove;
    }

    public final boolean hasRunbooks() {
        return this.runbooks != null && !(this.runbooks instanceof SdkAutoConstructList);
    }

    public final List<Runbook> runbooks() {
        return this.runbooks;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant scheduledEndTime() {
        return this.scheduledEndTime;
    }

    public final String changeDetails() {
        return this.changeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeRequestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoApprove());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRunbooks() ? this.runbooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChangeRequestExecutionRequest)) {
            return false;
        }
        StartChangeRequestExecutionRequest other = (StartChangeRequestExecutionRequest)((Object)obj);
        return Objects.equals(this.scheduledTime(), other.scheduledTime()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.changeRequestName(), other.changeRequestName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.autoApprove(), other.autoApprove()) && this.hasRunbooks() == other.hasRunbooks() && Objects.equals(this.runbooks(), other.runbooks()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.scheduledEndTime(), other.scheduledEndTime()) && Objects.equals(this.changeDetails(), other.changeDetails());
    }

    public final String toString() {
        return ToString.builder((String)"StartChangeRequestExecutionRequest").add("ScheduledTime", (Object)this.scheduledTime()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ChangeRequestName", (Object)this.changeRequestName()).add("ClientToken", (Object)this.clientToken()).add("AutoApprove", (Object)this.autoApprove()).add("Runbooks", this.hasRunbooks() ? this.runbooks() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ScheduledEndTime", (Object)this.scheduledEndTime()).add("ChangeDetails", (Object)this.changeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ChangeRequestName": {
                return Optional.ofNullable(clazz.cast(this.changeRequestName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AutoApprove": {
                return Optional.ofNullable(clazz.cast(this.autoApprove()));
            }
            case "Runbooks": {
                return Optional.ofNullable(clazz.cast(this.runbooks()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ScheduledEndTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledEndTime()));
            }
            case "ChangeDetails": {
                return Optional.ofNullable(clazz.cast(this.changeDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChangeRequestExecutionRequest, T> g) {
        return obj -> g.apply((StartChangeRequestExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private Instant scheduledTime;
        private String documentName;
        private String documentVersion;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String changeRequestName;
        private String clientToken;
        private Boolean autoApprove;
        private List<Runbook> runbooks = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant scheduledEndTime;
        private String changeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChangeRequestExecutionRequest model) {
            super(model);
            this.scheduledTime(model.scheduledTime);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.changeRequestName(model.changeRequestName);
            this.clientToken(model.clientToken);
            this.autoApprove(model.autoApprove);
            this.runbooks(model.runbooks);
            this.tags(model.tags);
            this.scheduledEndTime(model.scheduledEndTime);
            this.changeDetails(model.changeDetails);
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final String getChangeRequestName() {
            return this.changeRequestName;
        }

        public final void setChangeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
        }

        @Override
        public final Builder changeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getAutoApprove() {
            return this.autoApprove;
        }

        public final void setAutoApprove(Boolean autoApprove) {
            this.autoApprove = autoApprove;
        }

        @Override
        public final Builder autoApprove(Boolean autoApprove) {
            this.autoApprove = autoApprove;
            return this;
        }

        public final List<Runbook.Builder> getRunbooks() {
            List<Runbook.Builder> result = RunbooksCopier.copyToBuilder(this.runbooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRunbooks(Collection<Runbook.BuilderImpl> runbooks) {
            this.runbooks = RunbooksCopier.copyFromBuilder(runbooks);
        }

        @Override
        public final Builder runbooks(Collection<Runbook> runbooks) {
            this.runbooks = RunbooksCopier.copy(runbooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Runbook ... runbooks) {
            this.runbooks(Arrays.asList(runbooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Consumer<Runbook.Builder> ... runbooks) {
            this.runbooks(Stream.of(runbooks).map(c -> (Runbook)((Runbook.Builder)Runbook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getScheduledEndTime() {
            return this.scheduledEndTime;
        }

        public final void setScheduledEndTime(Instant scheduledEndTime) {
            this.scheduledEndTime = scheduledEndTime;
        }

        @Override
        public final Builder scheduledEndTime(Instant scheduledEndTime) {
            this.scheduledEndTime = scheduledEndTime;
            return this;
        }

        public final String getChangeDetails() {
            return this.changeDetails;
        }

        public final void setChangeDetails(String changeDetails) {
            this.changeDetails = changeDetails;
        }

        @Override
        public final Builder changeDetails(String changeDetails) {
            this.changeDetails = changeDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChangeRequestExecutionRequest build() {
            return new StartChangeRequestExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartChangeRequestExecutionRequest> {
        public Builder scheduledTime(Instant var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder changeRequestName(String var1);

        public Builder clientToken(String var1);

        public Builder autoApprove(Boolean var1);

        public Builder runbooks(Collection<Runbook> var1);

        public Builder runbooks(Runbook ... var1);

        public Builder runbooks(Consumer<Runbook.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder scheduledEndTime(Instant var1);

        public Builder changeDetails(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

