/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.DefaultSsmBaseClientBuilder;
import software.amazon.awssdk.services.ssm.DefaultSsmClient;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.SsmServiceClientConfiguration;
import software.amazon.awssdk.services.ssm.endpoints.SsmEndpointProvider;

@SdkInternalApi
final class DefaultSsmClientBuilder
extends DefaultSsmBaseClientBuilder<SsmClientBuilder, SsmClient>
implements SsmClientBuilder {
    DefaultSsmClientBuilder() {
    }

    @Override
    public DefaultSsmClientBuilder endpointProvider(SsmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsmClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SsmServiceClientConfiguration serviceClientConfiguration = SsmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSsmClient(serviceClientConfiguration, clientConfiguration);
    }
}

