/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;

public class DescribeMaintenanceWindowExecutionsPublisher
implements SdkPublisher<DescribeMaintenanceWindowExecutionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowExecutionsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowExecutionsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowExecution> windowExecutions() {
        Function<DescribeMaintenanceWindowExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.windowExecutions() != null) {
                return response.windowExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMaintenanceWindowExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMaintenanceWindowExecutionsResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowExecutionsResponse> {
        private DescribeMaintenanceWindowExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> nextPage(DescribeMaintenanceWindowExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowExecutionsPublisher.this.client.describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowExecutionsPublisher.this.client.describeMaintenanceWindowExecutions((DescribeMaintenanceWindowExecutionsRequest)((Object)DescribeMaintenanceWindowExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

