/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;

public class ListResourceDataSyncPublisher
implements SdkPublisher<ListResourceDataSyncResponse> {
    private final SsmAsyncClient client;
    private final ListResourceDataSyncRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceDataSyncPublisher(SsmAsyncClient client, ListResourceDataSyncRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceDataSyncPublisher(SsmAsyncClient client, ListResourceDataSyncRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceDataSyncResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceDataSyncResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceDataSyncItem> resourceDataSyncItems() {
        Function<ListResourceDataSyncResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceDataSyncItems() != null) {
                return response.resourceDataSyncItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceDataSyncResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceDataSyncResponseFetcher
    implements AsyncPageFetcher<ListResourceDataSyncResponse> {
        private ListResourceDataSyncResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceDataSyncResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceDataSyncResponse> nextPage(ListResourceDataSyncResponse previousPage) {
            if (previousPage == null) {
                return ListResourceDataSyncPublisher.this.client.listResourceDataSync(ListResourceDataSyncPublisher.this.firstRequest);
            }
            return ListResourceDataSyncPublisher.this.client.listResourceDataSync((ListResourceDataSyncRequest)((Object)ListResourceDataSyncPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

