/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponseEntry;

public class GetResourcePoliciesPublisher
implements SdkPublisher<GetResourcePoliciesResponse> {
    private final SsmAsyncClient client;
    private final GetResourcePoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcePoliciesPublisher(SsmAsyncClient client, GetResourcePoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcePoliciesPublisher(SsmAsyncClient client, GetResourcePoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcePoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcePoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GetResourcePoliciesResponseEntry> policies() {
        Function<GetResourcePoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policies() != null) {
                return response.policies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcePoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcePoliciesResponseFetcher
    implements AsyncPageFetcher<GetResourcePoliciesResponse> {
        private GetResourcePoliciesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcePoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourcePoliciesResponse> nextPage(GetResourcePoliciesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcePoliciesPublisher.this.client.getResourcePolicies(GetResourcePoliciesPublisher.this.firstRequest);
            }
            return GetResourcePoliciesPublisher.this.client.getResourcePolicies((GetResourcePoliciesRequest)((Object)GetResourcePoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

