/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutomationExecutionStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    WAITING("Waiting"),
    SUCCESS("Success"),
    TIMED_OUT("TimedOut"),
    CANCELLING("Cancelling"),
    CANCELLED("Cancelled"),
    FAILED("Failed"),
    PENDING_APPROVAL("PendingApproval"),
    APPROVED("Approved"),
    REJECTED("Rejected"),
    SCHEDULED("Scheduled"),
    RUNBOOK_IN_PROGRESS("RunbookInProgress"),
    PENDING_CHANGE_CALENDAR_OVERRIDE("PendingChangeCalendarOverride"),
    CHANGE_CALENDAR_OVERRIDE_APPROVED("ChangeCalendarOverrideApproved"),
    CHANGE_CALENDAR_OVERRIDE_REJECTED("ChangeCalendarOverrideRejected"),
    COMPLETED_WITH_SUCCESS("CompletedWithSuccess"),
    COMPLETED_WITH_FAILURE("CompletedWithFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutomationExecutionStatus> VALUE_MAP;
    private final String value;

    private AutomationExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutomationExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutomationExecutionStatus> knownValues() {
        EnumSet<AutomationExecutionStatus> knownValues = EnumSet.allOf(AutomationExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutomationExecutionStatus.class, AutomationExecutionStatus::toString);
    }
}

