/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.StepExecution;

public class DescribeAutomationStepExecutionsPublisher
implements SdkPublisher<DescribeAutomationStepExecutionsResponse> {
    private final SsmAsyncClient client;
    private final DescribeAutomationStepExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAutomationStepExecutionsPublisher(SsmAsyncClient client, DescribeAutomationStepExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAutomationStepExecutionsPublisher(SsmAsyncClient client, DescribeAutomationStepExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAutomationStepExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAutomationStepExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StepExecution> stepExecutions() {
        Function<DescribeAutomationStepExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stepExecutions() != null) {
                return response.stepExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAutomationStepExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAutomationStepExecutionsResponseFetcher
    implements AsyncPageFetcher<DescribeAutomationStepExecutionsResponse> {
        private DescribeAutomationStepExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutomationStepExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAutomationStepExecutionsResponse> nextPage(DescribeAutomationStepExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutomationStepExecutionsPublisher.this.client.describeAutomationStepExecutions(DescribeAutomationStepExecutionsPublisher.this.firstRequest);
            }
            return DescribeAutomationStepExecutionsPublisher.this.client.describeAutomationStepExecutions((DescribeAutomationStepExecutionsRequest)((Object)DescribeAutomationStepExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

