/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssociationFilterKey {
    INSTANCE_ID("InstanceId"),
    NAME("Name"),
    ASSOCIATION_ID("AssociationId"),
    ASSOCIATION_STATUS_NAME("AssociationStatusName"),
    LAST_EXECUTED_BEFORE("LastExecutedBefore"),
    LAST_EXECUTED_AFTER("LastExecutedAfter"),
    ASSOCIATION_NAME("AssociationName"),
    RESOURCE_GROUP_NAME("ResourceGroupName"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssociationFilterKey> VALUE_MAP;
    private final String value;

    private AssociationFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssociationFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssociationFilterKey> knownValues() {
        EnumSet<AssociationFilterKey> knownValues = EnumSet.allOf(AssociationFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssociationFilterKey.class, AssociationFilterKey::toString);
    }
}

