/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsAggregator;
import software.amazon.awssdk.services.ssm.model.OpsAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.OpsFilter;
import software.amazon.awssdk.services.ssm.model.OpsFilterListCopier;
import software.amazon.awssdk.services.ssm.model.OpsResultAttribute;
import software.amazon.awssdk.services.ssm.model.OpsResultAttributeListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOpsSummaryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetOpsSummaryRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncName").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::syncName)).setter(GetOpsSummaryRequest.setter(Builder::syncName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()}).build();
    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::filters)).setter(GetOpsSummaryRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::aggregators)).setter(GetOpsSummaryRequest.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OpsResultAttribute>> RESULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultAttributes").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::resultAttributes)).setter(GetOpsSummaryRequest.setter(Builder::resultAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsResultAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::nextToken)).setter(GetOpsSummaryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetOpsSummaryRequest.getter(GetOpsSummaryRequest::maxResults)).setter(GetOpsSummaryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD, FILTERS_FIELD, AGGREGATORS_FIELD, RESULT_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String syncName;
    private final List<OpsFilter> filters;
    private final List<OpsAggregator> aggregators;
    private final List<OpsResultAttribute> resultAttributes;
    private final String nextToken;
    private final Integer maxResults;

    private GetOpsSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String syncName() {
        return this.syncName;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<OpsFilter> filters() {
        return this.filters;
    }

    public final boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public final List<OpsAggregator> aggregators() {
        return this.aggregators;
    }

    public final boolean hasResultAttributes() {
        return this.resultAttributes != null && !(this.resultAttributes instanceof SdkAutoConstructList);
    }

    public final List<OpsResultAttribute> resultAttributes() {
        return this.resultAttributes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultAttributes() ? this.resultAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsSummaryRequest)) {
            return false;
        }
        GetOpsSummaryRequest other = (GetOpsSummaryRequest)((Object)obj);
        return Objects.equals(this.syncName(), other.syncName()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators()) && this.hasResultAttributes() == other.hasResultAttributes() && Objects.equals(this.resultAttributes(), other.resultAttributes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetOpsSummaryRequest").add("SyncName", (Object)this.syncName()).add("Filters", this.hasFilters() ? this.filters() : null).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).add("ResultAttributes", this.hasResultAttributes() ? this.resultAttributes() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.ofNullable(clazz.cast(this.syncName()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
            case "ResultAttributes": {
                return Optional.ofNullable(clazz.cast(this.resultAttributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpsSummaryRequest, T> g) {
        return obj -> g.apply((GetOpsSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String syncName;
        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();
        private List<OpsResultAttribute> resultAttributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpsSummaryRequest model) {
            super(model);
            this.syncName(model.syncName);
            this.filters(model.filters);
            this.aggregators(model.aggregators);
            this.resultAttributes(model.resultAttributes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        @Transient
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final List<OpsFilter.Builder> getFilters() {
            List<OpsFilter.Builder> result = OpsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(OpsFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (OpsFilter)((OpsFilter.Builder)OpsFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OpsAggregator.Builder> getAggregators() {
            List<OpsAggregator.Builder> result = OpsAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<OpsAggregator.BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        @Transient
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregators(OpsAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregators(Consumer<OpsAggregator.Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (OpsAggregator)((OpsAggregator.Builder)OpsAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OpsResultAttribute.Builder> getResultAttributes() {
            List<OpsResultAttribute.Builder> result = OpsResultAttributeListCopier.copyToBuilder(this.resultAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultAttributes(Collection<OpsResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = OpsResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        @Override
        @Transient
        public final Builder resultAttributes(Collection<OpsResultAttribute> resultAttributes) {
            this.resultAttributes = OpsResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultAttributes(OpsResultAttribute ... resultAttributes) {
            this.resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultAttributes(Consumer<OpsResultAttribute.Builder> ... resultAttributes) {
            this.resultAttributes(Stream.of(resultAttributes).map(c -> (OpsResultAttribute)((OpsResultAttribute.Builder)OpsResultAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOpsSummaryRequest build() {
            return new GetOpsSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOpsSummaryRequest> {
        public Builder syncName(String var1);

        public Builder filters(Collection<OpsFilter> var1);

        public Builder filters(OpsFilter ... var1);

        public Builder filters(Consumer<OpsFilter.Builder> ... var1);

        public Builder aggregators(Collection<OpsAggregator> var1);

        public Builder aggregators(OpsAggregator ... var1);

        public Builder aggregators(Consumer<OpsAggregator.Builder> ... var1);

        public Builder resultAttributes(Collection<OpsResultAttribute> var1);

        public Builder resultAttributes(OpsResultAttribute ... var1);

        public Builder resultAttributes(Consumer<OpsResultAttribute.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

