/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceSummaryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceSummaryItem> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ComplianceSummaryItem.getter(ComplianceSummaryItem::complianceType)).setter(ComplianceSummaryItem.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<CompliantSummary> COMPLIANT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompliantSummary").getter(ComplianceSummaryItem.getter(ComplianceSummaryItem::compliantSummary)).setter(ComplianceSummaryItem.setter(Builder::compliantSummary)).constructor(CompliantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantSummary").build()}).build();
    private static final SdkField<NonCompliantSummary> NON_COMPLIANT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NonCompliantSummary").getter(ComplianceSummaryItem.getter(ComplianceSummaryItem::nonCompliantSummary)).setter(ComplianceSummaryItem.setter(Builder::nonCompliantSummary)).constructor(NonCompliantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, COMPLIANT_SUMMARY_FIELD, NON_COMPLIANT_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final CompliantSummary compliantSummary;
    private final NonCompliantSummary nonCompliantSummary;

    private ComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    public final String complianceType() {
        return this.complianceType;
    }

    public final CompliantSummary compliantSummary() {
        return this.compliantSummary;
    }

    public final NonCompliantSummary nonCompliantSummary() {
        return this.nonCompliantSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryItem)) {
            return false;
        }
        ComplianceSummaryItem other = (ComplianceSummaryItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.compliantSummary(), other.compliantSummary()) && Objects.equals(this.nonCompliantSummary(), other.nonCompliantSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ComplianceSummaryItem").add("ComplianceType", (Object)this.complianceType()).add("CompliantSummary", (Object)this.compliantSummary()).add("NonCompliantSummary", (Object)this.nonCompliantSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "CompliantSummary": {
                return Optional.ofNullable(clazz.cast(this.compliantSummary()));
            }
            case "NonCompliantSummary": {
                return Optional.ofNullable(clazz.cast(this.nonCompliantSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceSummaryItem, T> g) {
        return obj -> g.apply((ComplianceSummaryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private CompliantSummary compliantSummary;
        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryItem model) {
            this.complianceType(model.complianceType);
            this.compliantSummary(model.compliantSummary);
            this.nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return this.compliantSummary != null ? this.compliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return this.nonCompliantSummary != null ? this.nonCompliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        public ComplianceSummaryItem build() {
            return new ComplianceSummaryItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceSummaryItem> {
        public Builder complianceType(String var1);

        public Builder compliantSummary(CompliantSummary var1);

        default public Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return this.compliantSummary((CompliantSummary)((CompliantSummary.Builder)CompliantSummary.builder().applyMutation(compliantSummary)).build());
        }

        public Builder nonCompliantSummary(NonCompliantSummary var1);

        default public Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return this.nonCompliantSummary((NonCompliantSummary)((NonCompliantSummary.Builder)NonCompliantSummary.builder().applyMutation(nonCompliantSummary)).build());
        }
    }
}

