/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncDestinationDataSharing;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataSyncS3Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDataSyncS3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::bucketName)).setter(ResourceDataSyncS3Destination.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::prefix)).setter(ResourceDataSyncS3Destination.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> SYNC_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncFormat").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::syncFormatAsString)).setter(ResourceDataSyncS3Destination.setter(Builder::syncFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncFormat").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::region)).setter(ResourceDataSyncS3Destination.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> AWSKMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSKMSKeyARN").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::awskmsKeyARN)).setter(ResourceDataSyncS3Destination.setter(Builder::awskmsKeyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSKMSKeyARN").build()}).build();
    private static final SdkField<ResourceDataSyncDestinationDataSharing> DESTINATION_DATA_SHARING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationDataSharing").getter(ResourceDataSyncS3Destination.getter(ResourceDataSyncS3Destination::destinationDataSharing)).setter(ResourceDataSyncS3Destination.setter(Builder::destinationDataSharing)).constructor(ResourceDataSyncDestinationDataSharing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDataSharing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PREFIX_FIELD, SYNC_FORMAT_FIELD, REGION_FIELD, AWSKMS_KEY_ARN_FIELD, DESTINATION_DATA_SHARING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String prefix;
    private final String syncFormat;
    private final String region;
    private final String awskmsKeyARN;
    private final ResourceDataSyncDestinationDataSharing destinationDataSharing;

    private ResourceDataSyncS3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.syncFormat = builder.syncFormat;
        this.region = builder.region;
        this.awskmsKeyARN = builder.awskmsKeyARN;
        this.destinationDataSharing = builder.destinationDataSharing;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final ResourceDataSyncS3Format syncFormat() {
        return ResourceDataSyncS3Format.fromValue(this.syncFormat);
    }

    public final String syncFormatAsString() {
        return this.syncFormat;
    }

    public final String region() {
        return this.region;
    }

    public final String awskmsKeyARN() {
        return this.awskmsKeyARN;
    }

    public final ResourceDataSyncDestinationDataSharing destinationDataSharing() {
        return this.destinationDataSharing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.awskmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDataSharing());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncS3Destination)) {
            return false;
        }
        ResourceDataSyncS3Destination other = (ResourceDataSyncS3Destination)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.syncFormatAsString(), other.syncFormatAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.awskmsKeyARN(), other.awskmsKeyARN()) && Objects.equals(this.destinationDataSharing(), other.destinationDataSharing());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceDataSyncS3Destination").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("SyncFormat", (Object)this.syncFormatAsString()).add("Region", (Object)this.region()).add("AWSKMSKeyARN", (Object)this.awskmsKeyARN()).add("DestinationDataSharing", (Object)this.destinationDataSharing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "SyncFormat": {
                return Optional.ofNullable(clazz.cast(this.syncFormatAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AWSKMSKeyARN": {
                return Optional.ofNullable(clazz.cast(this.awskmsKeyARN()));
            }
            case "DestinationDataSharing": {
                return Optional.ofNullable(clazz.cast(this.destinationDataSharing()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncS3Destination, T> g) {
        return obj -> g.apply((ResourceDataSyncS3Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private String syncFormat;
        private String region;
        private String awskmsKeyARN;
        private ResourceDataSyncDestinationDataSharing destinationDataSharing;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncS3Destination model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.syncFormat(model.syncFormat);
            this.region(model.region);
            this.awskmsKeyARN(model.awskmsKeyARN);
            this.destinationDataSharing(model.destinationDataSharing);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSyncFormat() {
            return this.syncFormat;
        }

        public final void setSyncFormat(String syncFormat) {
            this.syncFormat = syncFormat;
        }

        @Override
        @Transient
        public final Builder syncFormat(String syncFormat) {
            this.syncFormat = syncFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder syncFormat(ResourceDataSyncS3Format syncFormat) {
            this.syncFormat(syncFormat == null ? null : syncFormat.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAwskmsKeyARN() {
            return this.awskmsKeyARN;
        }

        public final void setAwskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        @Override
        @Transient
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final ResourceDataSyncDestinationDataSharing.Builder getDestinationDataSharing() {
            return this.destinationDataSharing != null ? this.destinationDataSharing.toBuilder() : null;
        }

        public final void setDestinationDataSharing(ResourceDataSyncDestinationDataSharing.BuilderImpl destinationDataSharing) {
            this.destinationDataSharing = destinationDataSharing != null ? destinationDataSharing.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationDataSharing(ResourceDataSyncDestinationDataSharing destinationDataSharing) {
            this.destinationDataSharing = destinationDataSharing;
            return this;
        }

        public ResourceDataSyncS3Destination build() {
            return new ResourceDataSyncS3Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDataSyncS3Destination> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder syncFormat(String var1);

        public Builder syncFormat(ResourceDataSyncS3Format var1);

        public Builder region(String var1);

        public Builder awskmsKeyARN(String var1);

        public Builder destinationDataSharing(ResourceDataSyncDestinationDataSharing var1);

        default public Builder destinationDataSharing(Consumer<ResourceDataSyncDestinationDataSharing.Builder> destinationDataSharing) {
            return this.destinationDataSharing((ResourceDataSyncDestinationDataSharing)((ResourceDataSyncDestinationDataSharing.Builder)ResourceDataSyncDestinationDataSharing.builder().applyMutation(destinationDataSharing)).build());
        }
    }
}

