/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.CloudWatchOutputConfig;
import software.amazon.awssdk.services.ssm.model.CommandStatus;
import software.amazon.awssdk.services.ssm.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Command
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Command> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommandId").getter(Command.getter(Command::commandId)).setter(Command.setter(Builder::commandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentName").getter(Command.getter(Command::documentName)).setter(Command.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(Command.getter(Command::documentVersion)).setter(Command.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(Command.getter(Command::comment)).setter(Command.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<Instant> EXPIRES_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAfter").getter(Command.getter(Command::expiresAfter)).setter(Command.setter(Builder::expiresAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAfter").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(Command.getter(Command::parameters)).setter(Command.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(Command.getter(Command::instanceIds)).setter(Command.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(Command.getter(Command::targets)).setter(Command.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REQUESTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedDateTime").getter(Command.getter(Command::requestedDateTime)).setter(Command.setter(Builder::requestedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Command.getter(Command::statusAsString)).setter(Command.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(Command.getter(Command::statusDetails)).setter(Command.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<String> OUTPUT_S3_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3Region").getter(Command.getter(Command::outputS3Region)).setter(Command.setter(Builder::outputS3Region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Region").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3BucketName").getter(Command.getter(Command::outputS3BucketName)).setter(Command.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3KeyPrefix").getter(Command.getter(Command::outputS3KeyPrefix)).setter(Command.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(Command.getter(Command::maxConcurrency)).setter(Command.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(Command.getter(Command::maxErrors)).setter(Command.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCount").getter(Command.getter(Command::targetCount)).setter(Command.setter(Builder::targetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()}).build();
    private static final SdkField<Integer> COMPLETED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CompletedCount").getter(Command.getter(Command::completedCount)).setter(Command.setter(Builder::completedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedCount").build()}).build();
    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorCount").getter(Command.getter(Command::errorCount)).setter(Command.setter(Builder::errorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()}).build();
    private static final SdkField<Integer> DELIVERY_TIMED_OUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeliveryTimedOutCount").getter(Command.getter(Command::deliveryTimedOutCount)).setter(Command.setter(Builder::deliveryTimedOutCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTimedOutCount").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(Command.getter(Command::serviceRole)).setter(Command.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<NotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfig").getter(Command.getter(Command::notificationConfig)).setter(Command.setter(Builder::notificationConfig)).constructor(NotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig").getter(Command.getter(Command::cloudWatchOutputConfig)).setter(Command.setter(Builder::cloudWatchOutputConfig)).constructor(CloudWatchOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutSeconds").getter(Command.getter(Command::timeoutSeconds)).setter(Command.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, COMMENT_FIELD, EXPIRES_AFTER_FIELD, PARAMETERS_FIELD, INSTANCE_IDS_FIELD, TARGETS_FIELD, REQUESTED_DATE_TIME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, OUTPUT_S3_REGION_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_COUNT_FIELD, COMPLETED_COUNT_FIELD, ERROR_COUNT_FIELD, DELIVERY_TIMED_OUT_COUNT_FIELD, SERVICE_ROLE_FIELD, NOTIFICATION_CONFIG_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD, TIMEOUT_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String commandId;
    private final String documentName;
    private final String documentVersion;
    private final String comment;
    private final Instant expiresAfter;
    private final Map<String, List<String>> parameters;
    private final List<String> instanceIds;
    private final List<Target> targets;
    private final Instant requestedDateTime;
    private final String status;
    private final String statusDetails;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String maxConcurrency;
    private final String maxErrors;
    private final Integer targetCount;
    private final Integer completedCount;
    private final Integer errorCount;
    private final Integer deliveryTimedOutCount;
    private final String serviceRole;
    private final NotificationConfig notificationConfig;
    private final CloudWatchOutputConfig cloudWatchOutputConfig;
    private final Integer timeoutSeconds;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.comment = builder.comment;
        this.expiresAfter = builder.expiresAfter;
        this.parameters = builder.parameters;
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetCount = builder.targetCount;
        this.completedCount = builder.completedCount;
        this.errorCount = builder.errorCount;
        this.deliveryTimedOutCount = builder.deliveryTimedOutCount;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public final String commandId() {
        return this.commandId;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String comment() {
        return this.comment;
    }

    public final Instant expiresAfter() {
        return this.expiresAfter;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final Instant requestedDateTime() {
        return this.requestedDateTime;
    }

    public final CommandStatus status() {
        return CommandStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final String outputS3Region() {
        return this.outputS3Region;
    }

    public final String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public final String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final Integer targetCount() {
        return this.targetCount;
    }

    public final Integer completedCount() {
        return this.completedCount;
    }

    public final Integer errorCount() {
        return this.errorCount;
    }

    public final Integer deliveryTimedOutCount() {
        return this.deliveryTimedOutCount;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public final CloudWatchOutputConfig cloudWatchOutputConfig() {
        return this.cloudWatchOutputConfig;
    }

    public final Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryTimedOutCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.expiresAfter(), other.expiresAfter()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.requestedDateTime(), other.requestedDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.outputS3Region(), other.outputS3Region()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.targetCount(), other.targetCount()) && Objects.equals(this.completedCount(), other.completedCount()) && Objects.equals(this.errorCount(), other.errorCount()) && Objects.equals(this.deliveryTimedOutCount(), other.deliveryTimedOutCount()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.cloudWatchOutputConfig(), other.cloudWatchOutputConfig()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"Command").add("CommandId", (Object)this.commandId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("Comment", (Object)this.comment()).add("ExpiresAfter", (Object)this.expiresAfter()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("RequestedDateTime", (Object)this.requestedDateTime()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("OutputS3Region", (Object)this.outputS3Region()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("TargetCount", (Object)this.targetCount()).add("CompletedCount", (Object)this.completedCount()).add("ErrorCount", (Object)this.errorCount()).add("DeliveryTimedOutCount", (Object)this.deliveryTimedOutCount()).add("ServiceRole", (Object)this.serviceRole()).add("NotificationConfig", (Object)this.notificationConfig()).add("CloudWatchOutputConfig", (Object)this.cloudWatchOutputConfig()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.ofNullable(clazz.cast(this.commandId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "ExpiresAfter": {
                return Optional.ofNullable(clazz.cast(this.expiresAfter()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "RequestedDateTime": {
                return Optional.ofNullable(clazz.cast(this.requestedDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "OutputS3Region": {
                return Optional.ofNullable(clazz.cast(this.outputS3Region()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "TargetCount": {
                return Optional.ofNullable(clazz.cast(this.targetCount()));
            }
            case "CompletedCount": {
                return Optional.ofNullable(clazz.cast(this.completedCount()));
            }
            case "ErrorCount": {
                return Optional.ofNullable(clazz.cast(this.errorCount()));
            }
            case "DeliveryTimedOutCount": {
                return Optional.ofNullable(clazz.cast(this.deliveryTimedOutCount()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
            case "CloudWatchOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputConfig()));
            }
            case "TimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String documentName;
        private String documentVersion;
        private String comment;
        private Instant expiresAfter;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private Instant requestedDateTime;
        private String status;
        private String statusDetails;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String maxConcurrency;
        private String maxErrors;
        private Integer targetCount;
        private Integer completedCount;
        private Integer errorCount;
        private Integer deliveryTimedOutCount;
        private String serviceRole;
        private NotificationConfig notificationConfig;
        private CloudWatchOutputConfig cloudWatchOutputConfig;
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.commandId(model.commandId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.comment(model.comment);
            this.expiresAfter(model.expiresAfter);
            this.parameters(model.parameters);
            this.instanceIds(model.instanceIds);
            this.targets(model.targets);
            this.requestedDateTime(model.requestedDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.outputS3Region(model.outputS3Region);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.targetCount(model.targetCount);
            this.completedCount(model.completedCount);
            this.errorCount(model.errorCount);
            this.deliveryTimedOutCount(model.deliveryTimedOutCount);
            this.serviceRole(model.serviceRole);
            this.notificationConfig(model.notificationConfig);
            this.cloudWatchOutputConfig(model.cloudWatchOutputConfig);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        @Transient
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        @Transient
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getExpiresAfter() {
            return this.expiresAfter;
        }

        public final void setExpiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        @Override
        @Transient
        public final Builder expiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        @Override
        @Transient
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getRequestedDateTime() {
            return this.requestedDateTime;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        @Override
        @Transient
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CommandStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        @Transient
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        @Override
        @Transient
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        @Override
        @Transient
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        @Transient
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        @Transient
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        @Transient
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        @Override
        @Transient
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final Integer getCompletedCount() {
            return this.completedCount;
        }

        public final void setCompletedCount(Integer completedCount) {
            this.completedCount = completedCount;
        }

        @Override
        @Transient
        public final Builder completedCount(Integer completedCount) {
            this.completedCount = completedCount;
            return this;
        }

        public final Integer getErrorCount() {
            return this.errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        @Transient
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final Integer getDeliveryTimedOutCount() {
            return this.deliveryTimedOutCount;
        }

        public final void setDeliveryTimedOutCount(Integer deliveryTimedOutCount) {
            this.deliveryTimedOutCount = deliveryTimedOutCount;
        }

        @Override
        @Transient
        public final Builder deliveryTimedOutCount(Integer deliveryTimedOutCount) {
            this.deliveryTimedOutCount = deliveryTimedOutCount;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.toBuilder() : null;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        @Transient
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Command build() {
            return new Command(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Command> {
        public Builder commandId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder comment(String var1);

        public Builder expiresAfter(Instant var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder requestedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CommandStatus var1);

        public Builder statusDetails(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder targetCount(Integer var1);

        public Builder completedCount(Integer var1);

        public Builder errorCount(Integer var1);

        public Builder deliveryTimedOutCount(Integer var1);

        public Builder serviceRole(String var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().applyMutation(notificationConfig)).build());
        }

        public Builder cloudWatchOutputConfig(CloudWatchOutputConfig var1);

        default public Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return this.cloudWatchOutputConfig((CloudWatchOutputConfig)((CloudWatchOutputConfig.Builder)CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig)).build());
        }

        public Builder timeoutSeconds(Integer var1);
    }
}

