/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AttachmentInformation;
import software.amazon.awssdk.services.ssm.model.AttachmentInformationListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.DocumentParameter;
import software.amazon.awssdk.services.ssm.model.DocumentParameterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentRequires;
import software.amazon.awssdk.services.ssm.model.DocumentRequiresListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentStatus;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.model.ReviewInformation;
import software.amazon.awssdk.services.ssm.model.ReviewInformationListCopier;
import software.amazon.awssdk.services.ssm.model.ReviewStatus;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentDescription> {
    private static final SdkField<String> SHA1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sha1").getter(DocumentDescription.getter(DocumentDescription::sha1)).setter(DocumentDescription.setter(Builder::sha1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sha1").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(DocumentDescription.getter(DocumentDescription::hash)).setter(DocumentDescription.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()}).build();
    private static final SdkField<String> HASH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HashType").getter(DocumentDescription.getter(DocumentDescription::hashTypeAsString)).setter(DocumentDescription.setter(Builder::hashType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DocumentDescription.getter(DocumentDescription::name)).setter(DocumentDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DocumentDescription.getter(DocumentDescription::displayName)).setter(DocumentDescription.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(DocumentDescription.getter(DocumentDescription::versionName)).setter(DocumentDescription.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(DocumentDescription.getter(DocumentDescription::owner)).setter(DocumentDescription.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DocumentDescription.getter(DocumentDescription::createdDate)).setter(DocumentDescription.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DocumentDescription.getter(DocumentDescription::statusAsString)).setter(DocumentDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusInformation").getter(DocumentDescription.getter(DocumentDescription::statusInformation)).setter(DocumentDescription.setter(Builder::statusInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInformation").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(DocumentDescription.getter(DocumentDescription::documentVersion)).setter(DocumentDescription.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DocumentDescription.getter(DocumentDescription::description)).setter(DocumentDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<DocumentParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(DocumentDescription.getter(DocumentDescription::parameters)).setter(DocumentDescription.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PLATFORM_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlatformTypes").getter(DocumentDescription.getter(DocumentDescription::platformTypesAsStrings)).setter(DocumentDescription.setter(Builder::platformTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentType").getter(DocumentDescription.getter(DocumentDescription::documentTypeAsString)).setter(DocumentDescription.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersion").getter(DocumentDescription.getter(DocumentDescription::schemaVersion)).setter(DocumentDescription.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestVersion").getter(DocumentDescription.getter(DocumentDescription::latestVersion)).setter(DocumentDescription.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultVersion").getter(DocumentDescription.getter(DocumentDescription::defaultVersion)).setter(DocumentDescription.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentFormat").getter(DocumentDescription.getter(DocumentDescription::documentFormatAsString)).setter(DocumentDescription.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(DocumentDescription.getter(DocumentDescription::targetType)).setter(DocumentDescription.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DocumentDescription.getter(DocumentDescription::tags)).setter(DocumentDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentInformation>> ATTACHMENTS_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentsInformation").getter(DocumentDescription.getter(DocumentDescription::attachmentsInformation)).setter(DocumentDescription.setter(Builder::attachmentsInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentsInformation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentRequires>> REQUIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Requires").getter(DocumentDescription.getter(DocumentDescription::requires)).setter(DocumentDescription.setter(Builder::requires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requires").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentRequires::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(DocumentDescription.getter(DocumentDescription::author)).setter(DocumentDescription.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Author").build()}).build();
    private static final SdkField<List<ReviewInformation>> REVIEW_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReviewInformation").getter(DocumentDescription.getter(DocumentDescription::reviewInformation)).setter(DocumentDescription.setter(Builder::reviewInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewInformation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPROVED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovedVersion").getter(DocumentDescription.getter(DocumentDescription::approvedVersion)).setter(DocumentDescription.setter(Builder::approvedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedVersion").build()}).build();
    private static final SdkField<String> PENDING_REVIEW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingReviewVersion").getter(DocumentDescription.getter(DocumentDescription::pendingReviewVersion)).setter(DocumentDescription.setter(Builder::pendingReviewVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingReviewVersion").build()}).build();
    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatus").getter(DocumentDescription.getter(DocumentDescription::reviewStatusAsString)).setter(DocumentDescription.setter(Builder::reviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHA1_FIELD, HASH_FIELD, HASH_TYPE_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, VERSION_NAME_FIELD, OWNER_FIELD, CREATED_DATE_FIELD, STATUS_FIELD, STATUS_INFORMATION_FIELD, DOCUMENT_VERSION_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, PLATFORM_TYPES_FIELD, DOCUMENT_TYPE_FIELD, SCHEMA_VERSION_FIELD, LATEST_VERSION_FIELD, DEFAULT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD, TARGET_TYPE_FIELD, TAGS_FIELD, ATTACHMENTS_INFORMATION_FIELD, REQUIRES_FIELD, AUTHOR_FIELD, REVIEW_INFORMATION_FIELD, APPROVED_VERSION_FIELD, PENDING_REVIEW_VERSION_FIELD, REVIEW_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sha1;
    private final String hash;
    private final String hashType;
    private final String name;
    private final String displayName;
    private final String versionName;
    private final String owner;
    private final Instant createdDate;
    private final String status;
    private final String statusInformation;
    private final String documentVersion;
    private final String description;
    private final List<DocumentParameter> parameters;
    private final List<String> platformTypes;
    private final String documentType;
    private final String schemaVersion;
    private final String latestVersion;
    private final String defaultVersion;
    private final String documentFormat;
    private final String targetType;
    private final List<Tag> tags;
    private final List<AttachmentInformation> attachmentsInformation;
    private final List<DocumentRequires> requires;
    private final String author;
    private final List<ReviewInformation> reviewInformation;
    private final String approvedVersion;
    private final String pendingReviewVersion;
    private final String reviewStatus;

    private DocumentDescription(BuilderImpl builder) {
        this.sha1 = builder.sha1;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.versionName = builder.versionName;
        this.owner = builder.owner;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.statusInformation = builder.statusInformation;
        this.documentVersion = builder.documentVersion;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.platformTypes = builder.platformTypes;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.latestVersion = builder.latestVersion;
        this.defaultVersion = builder.defaultVersion;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
        this.attachmentsInformation = builder.attachmentsInformation;
        this.requires = builder.requires;
        this.author = builder.author;
        this.reviewInformation = builder.reviewInformation;
        this.approvedVersion = builder.approvedVersion;
        this.pendingReviewVersion = builder.pendingReviewVersion;
        this.reviewStatus = builder.reviewStatus;
    }

    public final String sha1() {
        return this.sha1;
    }

    public final String hash() {
        return this.hash;
    }

    public final DocumentHashType hashType() {
        return DocumentHashType.fromValue(this.hashType);
    }

    public final String hashTypeAsString() {
        return this.hashType;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String owner() {
        return this.owner;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final DocumentStatus status() {
        return DocumentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusInformation() {
        return this.statusInformation;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<DocumentParameter> parameters() {
        return this.parameters;
    }

    public final List<PlatformType> platformTypes() {
        return PlatformTypeListCopier.copyStringToEnum(this.platformTypes);
    }

    public final boolean hasPlatformTypes() {
        return this.platformTypes != null && !(this.platformTypes instanceof SdkAutoConstructList);
    }

    public final List<String> platformTypesAsStrings() {
        return this.platformTypes;
    }

    public final DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public final String documentTypeAsString() {
        return this.documentType;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final String latestVersion() {
        return this.latestVersion;
    }

    public final String defaultVersion() {
        return this.defaultVersion;
    }

    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public final String documentFormatAsString() {
        return this.documentFormat;
    }

    public final String targetType() {
        return this.targetType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAttachmentsInformation() {
        return this.attachmentsInformation != null && !(this.attachmentsInformation instanceof SdkAutoConstructList);
    }

    public final List<AttachmentInformation> attachmentsInformation() {
        return this.attachmentsInformation;
    }

    public final boolean hasRequires() {
        return this.requires != null && !(this.requires instanceof SdkAutoConstructList);
    }

    public final List<DocumentRequires> requires() {
        return this.requires;
    }

    public final String author() {
        return this.author;
    }

    public final boolean hasReviewInformation() {
        return this.reviewInformation != null && !(this.reviewInformation instanceof SdkAutoConstructList);
    }

    public final List<ReviewInformation> reviewInformation() {
        return this.reviewInformation;
    }

    public final String approvedVersion() {
        return this.approvedVersion;
    }

    public final String pendingReviewVersion() {
        return this.pendingReviewVersion;
    }

    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(this.reviewStatus);
    }

    public final String reviewStatusAsString() {
        return this.reviewStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sha1());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformTypes() ? this.platformTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentsInformation() ? this.attachmentsInformation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequires() ? this.requires() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReviewInformation() ? this.reviewInformation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingReviewVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        return Objects.equals(this.sha1(), other.sha1()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.hashTypeAsString(), other.hashTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusInformation(), other.statusInformation()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.description(), other.description()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasPlatformTypes() == other.hasPlatformTypes() && Objects.equals(this.platformTypesAsStrings(), other.platformTypesAsStrings()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString()) && Objects.equals(this.targetType(), other.targetType()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAttachmentsInformation() == other.hasAttachmentsInformation() && Objects.equals(this.attachmentsInformation(), other.attachmentsInformation()) && this.hasRequires() == other.hasRequires() && Objects.equals(this.requires(), other.requires()) && Objects.equals(this.author(), other.author()) && this.hasReviewInformation() == other.hasReviewInformation() && Objects.equals(this.reviewInformation(), other.reviewInformation()) && Objects.equals(this.approvedVersion(), other.approvedVersion()) && Objects.equals(this.pendingReviewVersion(), other.pendingReviewVersion()) && Objects.equals(this.reviewStatusAsString(), other.reviewStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentDescription").add("Sha1", (Object)this.sha1()).add("Hash", (Object)this.hash()).add("HashType", (Object)this.hashTypeAsString()).add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("VersionName", (Object)this.versionName()).add("Owner", (Object)this.owner()).add("CreatedDate", (Object)this.createdDate()).add("Status", (Object)this.statusAsString()).add("StatusInformation", (Object)this.statusInformation()).add("DocumentVersion", (Object)this.documentVersion()).add("Description", (Object)this.description()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("PlatformTypes", this.hasPlatformTypes() ? this.platformTypesAsStrings() : null).add("DocumentType", (Object)this.documentTypeAsString()).add("SchemaVersion", (Object)this.schemaVersion()).add("LatestVersion", (Object)this.latestVersion()).add("DefaultVersion", (Object)this.defaultVersion()).add("DocumentFormat", (Object)this.documentFormatAsString()).add("TargetType", (Object)this.targetType()).add("Tags", this.hasTags() ? this.tags() : null).add("AttachmentsInformation", this.hasAttachmentsInformation() ? this.attachmentsInformation() : null).add("Requires", this.hasRequires() ? this.requires() : null).add("Author", (Object)this.author()).add("ReviewInformation", this.hasReviewInformation() ? this.reviewInformation() : null).add("ApprovedVersion", (Object)this.approvedVersion()).add("PendingReviewVersion", (Object)this.pendingReviewVersion()).add("ReviewStatus", (Object)this.reviewStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sha1": {
                return Optional.ofNullable(clazz.cast(this.sha1()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "HashType": {
                return Optional.ofNullable(clazz.cast(this.hashTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusInformation": {
                return Optional.ofNullable(clazz.cast(this.statusInformation()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "PlatformTypes": {
                return Optional.ofNullable(clazz.cast(this.platformTypesAsStrings()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "DefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AttachmentsInformation": {
                return Optional.ofNullable(clazz.cast(this.attachmentsInformation()));
            }
            case "Requires": {
                return Optional.ofNullable(clazz.cast(this.requires()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "ReviewInformation": {
                return Optional.ofNullable(clazz.cast(this.reviewInformation()));
            }
            case "ApprovedVersion": {
                return Optional.ofNullable(clazz.cast(this.approvedVersion()));
            }
            case "PendingReviewVersion": {
                return Optional.ofNullable(clazz.cast(this.pendingReviewVersion()));
            }
            case "ReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentDescription, T> g) {
        return obj -> g.apply((DocumentDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sha1;
        private String hash;
        private String hashType;
        private String name;
        private String displayName;
        private String versionName;
        private String owner;
        private Instant createdDate;
        private String status;
        private String statusInformation;
        private String documentVersion;
        private String description;
        private List<DocumentParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> platformTypes = DefaultSdkAutoConstructList.getInstance();
        private String documentType;
        private String schemaVersion;
        private String latestVersion;
        private String defaultVersion;
        private String documentFormat;
        private String targetType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentInformation> attachmentsInformation = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentRequires> requires = DefaultSdkAutoConstructList.getInstance();
        private String author;
        private List<ReviewInformation> reviewInformation = DefaultSdkAutoConstructList.getInstance();
        private String approvedVersion;
        private String pendingReviewVersion;
        private String reviewStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDescription model) {
            this.sha1(model.sha1);
            this.hash(model.hash);
            this.hashType(model.hashType);
            this.name(model.name);
            this.displayName(model.displayName);
            this.versionName(model.versionName);
            this.owner(model.owner);
            this.createdDate(model.createdDate);
            this.status(model.status);
            this.statusInformation(model.statusInformation);
            this.documentVersion(model.documentVersion);
            this.description(model.description);
            this.parameters(model.parameters);
            this.platformTypesWithStrings(model.platformTypes);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
            this.latestVersion(model.latestVersion);
            this.defaultVersion(model.defaultVersion);
            this.documentFormat(model.documentFormat);
            this.targetType(model.targetType);
            this.tags(model.tags);
            this.attachmentsInformation(model.attachmentsInformation);
            this.requires(model.requires);
            this.author(model.author);
            this.reviewInformation(model.reviewInformation);
            this.approvedVersion(model.approvedVersion);
            this.pendingReviewVersion(model.pendingReviewVersion);
            this.reviewStatus(model.reviewStatus);
        }

        public final String getSha1() {
            return this.sha1;
        }

        @Override
        public final Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public final void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public final String getHash() {
            return this.hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashType() {
            return this.hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(DocumentHashType hashType) {
            this.hashType(hashType == null ? null : hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusInformation() {
            return this.statusInformation;
        }

        @Override
        public final Builder statusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
            return this;
        }

        public final void setStatusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<DocumentParameter.Builder> getParameters() {
            List<DocumentParameter.Builder> result = DocumentParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(DocumentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<DocumentParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (DocumentParameter)((DocumentParameter.Builder)DocumentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<DocumentParameter.BuilderImpl> parameters) {
            this.parameters = DocumentParameterListCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getPlatformTypes() {
            if (this.platformTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypesWithStrings(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypesWithStrings(String ... platformTypes) {
            this.platformTypesWithStrings(Arrays.asList(platformTypes));
            return this;
        }

        @Override
        public final Builder platformTypes(Collection<PlatformType> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copyEnumToString(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(PlatformType ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final String getDocumentFormat() {
            return this.documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final List<AttachmentInformation.Builder> getAttachmentsInformation() {
            List<AttachmentInformation.Builder> result = AttachmentInformationListCopier.copyToBuilder(this.attachmentsInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attachmentsInformation(Collection<AttachmentInformation> attachmentsInformation) {
            this.attachmentsInformation = AttachmentInformationListCopier.copy(attachmentsInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsInformation(AttachmentInformation ... attachmentsInformation) {
            this.attachmentsInformation(Arrays.asList(attachmentsInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsInformation(Consumer<AttachmentInformation.Builder> ... attachmentsInformation) {
            this.attachmentsInformation(Stream.of(attachmentsInformation).map(c -> (AttachmentInformation)((AttachmentInformation.Builder)AttachmentInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentsInformation(Collection<AttachmentInformation.BuilderImpl> attachmentsInformation) {
            this.attachmentsInformation = AttachmentInformationListCopier.copyFromBuilder(attachmentsInformation);
        }

        public final List<DocumentRequires.Builder> getRequires() {
            List<DocumentRequires.Builder> result = DocumentRequiresListCopier.copyToBuilder(this.requires);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder requires(Collection<DocumentRequires> requires) {
            this.requires = DocumentRequiresListCopier.copy(requires);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(DocumentRequires ... requires) {
            this.requires(Arrays.asList(requires));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(Consumer<DocumentRequires.Builder> ... requires) {
            this.requires(Stream.of(requires).map(c -> (DocumentRequires)((DocumentRequires.Builder)DocumentRequires.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequires(Collection<DocumentRequires.BuilderImpl> requires) {
            this.requires = DocumentRequiresListCopier.copyFromBuilder(requires);
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final List<ReviewInformation.Builder> getReviewInformation() {
            List<ReviewInformation.Builder> result = ReviewInformationListCopier.copyToBuilder(this.reviewInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder reviewInformation(Collection<ReviewInformation> reviewInformation) {
            this.reviewInformation = ReviewInformationListCopier.copy(reviewInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewInformation(ReviewInformation ... reviewInformation) {
            this.reviewInformation(Arrays.asList(reviewInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewInformation(Consumer<ReviewInformation.Builder> ... reviewInformation) {
            this.reviewInformation(Stream.of(reviewInformation).map(c -> (ReviewInformation)((ReviewInformation.Builder)ReviewInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReviewInformation(Collection<ReviewInformation.BuilderImpl> reviewInformation) {
            this.reviewInformation = ReviewInformationListCopier.copyFromBuilder(reviewInformation);
        }

        public final String getApprovedVersion() {
            return this.approvedVersion;
        }

        @Override
        public final Builder approvedVersion(String approvedVersion) {
            this.approvedVersion = approvedVersion;
            return this;
        }

        public final void setApprovedVersion(String approvedVersion) {
            this.approvedVersion = approvedVersion;
        }

        public final String getPendingReviewVersion() {
            return this.pendingReviewVersion;
        }

        @Override
        public final Builder pendingReviewVersion(String pendingReviewVersion) {
            this.pendingReviewVersion = pendingReviewVersion;
            return this;
        }

        public final void setPendingReviewVersion(String pendingReviewVersion) {
            this.pendingReviewVersion = pendingReviewVersion;
        }

        public final String getReviewStatus() {
            return this.reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        public DocumentDescription build() {
            return new DocumentDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentDescription> {
        public Builder sha1(String var1);

        public Builder hash(String var1);

        public Builder hashType(String var1);

        public Builder hashType(DocumentHashType var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder versionName(String var1);

        public Builder owner(String var1);

        public Builder createdDate(Instant var1);

        public Builder status(String var1);

        public Builder status(DocumentStatus var1);

        public Builder statusInformation(String var1);

        public Builder documentVersion(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<DocumentParameter> var1);

        public Builder parameters(DocumentParameter ... var1);

        public Builder parameters(Consumer<DocumentParameter.Builder> ... var1);

        public Builder platformTypesWithStrings(Collection<String> var1);

        public Builder platformTypesWithStrings(String ... var1);

        public Builder platformTypes(Collection<PlatformType> var1);

        public Builder platformTypes(PlatformType ... var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder latestVersion(String var1);

        public Builder defaultVersion(String var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder targetType(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder attachmentsInformation(Collection<AttachmentInformation> var1);

        public Builder attachmentsInformation(AttachmentInformation ... var1);

        public Builder attachmentsInformation(Consumer<AttachmentInformation.Builder> ... var1);

        public Builder requires(Collection<DocumentRequires> var1);

        public Builder requires(DocumentRequires ... var1);

        public Builder requires(Consumer<DocumentRequires.Builder> ... var1);

        public Builder author(String var1);

        public Builder reviewInformation(Collection<ReviewInformation> var1);

        public Builder reviewInformation(ReviewInformation ... var1);

        public Builder reviewInformation(Consumer<ReviewInformation.Builder> ... var1);

        public Builder approvedVersion(String var1);

        public Builder pendingReviewVersion(String var1);

        public Builder reviewStatus(String var1);

        public Builder reviewStatus(ReviewStatus var1);
    }
}

