/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;

public class ListCommandsIterable
implements SdkIterable<ListCommandsResponse> {
    private final SsmClient client;
    private final ListCommandsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandsIterable(SsmClient client, ListCommandsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public Iterator<ListCommandsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Command> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commands() != null) {
                return response.commands().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommandsResponseFetcher
    implements SyncPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommandsResponse nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsIterable.this.client.listCommands(ListCommandsIterable.this.firstRequest);
            }
            return ListCommandsIterable.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

