/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.DocumentRequires;
import software.amazon.awssdk.services.ssm.model.DocumentRequiresListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.model.ReviewStatus;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentIdentifier> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DocumentIdentifier.getter(DocumentIdentifier::name)).setter(DocumentIdentifier.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DocumentIdentifier.getter(DocumentIdentifier::createdDate)).setter(DocumentIdentifier.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DocumentIdentifier.getter(DocumentIdentifier::displayName)).setter(DocumentIdentifier.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(DocumentIdentifier.getter(DocumentIdentifier::owner)).setter(DocumentIdentifier.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(DocumentIdentifier.getter(DocumentIdentifier::versionName)).setter(DocumentIdentifier.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<List<String>> PLATFORM_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlatformTypes").getter(DocumentIdentifier.getter(DocumentIdentifier::platformTypesAsStrings)).setter(DocumentIdentifier.setter(Builder::platformTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(DocumentIdentifier.getter(DocumentIdentifier::documentVersion)).setter(DocumentIdentifier.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentType").getter(DocumentIdentifier.getter(DocumentIdentifier::documentTypeAsString)).setter(DocumentIdentifier.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersion").getter(DocumentIdentifier.getter(DocumentIdentifier::schemaVersion)).setter(DocumentIdentifier.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentFormat").getter(DocumentIdentifier.getter(DocumentIdentifier::documentFormatAsString)).setter(DocumentIdentifier.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(DocumentIdentifier.getter(DocumentIdentifier::targetType)).setter(DocumentIdentifier.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DocumentIdentifier.getter(DocumentIdentifier::tags)).setter(DocumentIdentifier.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentRequires>> REQUIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Requires").getter(DocumentIdentifier.getter(DocumentIdentifier::requires)).setter(DocumentIdentifier.setter(Builder::requires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requires").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentRequires::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatus").getter(DocumentIdentifier.getter(DocumentIdentifier::reviewStatusAsString)).setter(DocumentIdentifier.setter(Builder::reviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(DocumentIdentifier.getter(DocumentIdentifier::author)).setter(DocumentIdentifier.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Author").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREATED_DATE_FIELD, DISPLAY_NAME_FIELD, OWNER_FIELD, VERSION_NAME_FIELD, PLATFORM_TYPES_FIELD, DOCUMENT_VERSION_FIELD, DOCUMENT_TYPE_FIELD, SCHEMA_VERSION_FIELD, DOCUMENT_FORMAT_FIELD, TARGET_TYPE_FIELD, TAGS_FIELD, REQUIRES_FIELD, REVIEW_STATUS_FIELD, AUTHOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant createdDate;
    private final String displayName;
    private final String owner;
    private final String versionName;
    private final List<String> platformTypes;
    private final String documentVersion;
    private final String documentType;
    private final String schemaVersion;
    private final String documentFormat;
    private final String targetType;
    private final List<Tag> tags;
    private final List<DocumentRequires> requires;
    private final String reviewStatus;
    private final String author;

    private DocumentIdentifier(BuilderImpl builder) {
        this.name = builder.name;
        this.createdDate = builder.createdDate;
        this.displayName = builder.displayName;
        this.owner = builder.owner;
        this.versionName = builder.versionName;
        this.platformTypes = builder.platformTypes;
        this.documentVersion = builder.documentVersion;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
        this.requires = builder.requires;
        this.reviewStatus = builder.reviewStatus;
        this.author = builder.author;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String owner() {
        return this.owner;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final List<PlatformType> platformTypes() {
        return PlatformTypeListCopier.copyStringToEnum(this.platformTypes);
    }

    public final boolean hasPlatformTypes() {
        return this.platformTypes != null && !(this.platformTypes instanceof SdkAutoConstructList);
    }

    public final List<String> platformTypesAsStrings() {
        return this.platformTypes;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public final String documentTypeAsString() {
        return this.documentType;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public final String documentFormatAsString() {
        return this.documentFormat;
    }

    public final String targetType() {
        return this.targetType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasRequires() {
        return this.requires != null && !(this.requires instanceof SdkAutoConstructList);
    }

    public final List<DocumentRequires> requires() {
        return this.requires;
    }

    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(this.reviewStatus);
    }

    public final String reviewStatusAsString() {
        return this.reviewStatus;
    }

    public final String author() {
        return this.author;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformTypes() ? this.platformTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequires() ? this.requires() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.versionName(), other.versionName()) && this.hasPlatformTypes() == other.hasPlatformTypes() && Objects.equals(this.platformTypesAsStrings(), other.platformTypesAsStrings()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString()) && Objects.equals(this.targetType(), other.targetType()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasRequires() == other.hasRequires() && Objects.equals(this.requires(), other.requires()) && Objects.equals(this.reviewStatusAsString(), other.reviewStatusAsString()) && Objects.equals(this.author(), other.author());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentIdentifier").add("Name", (Object)this.name()).add("CreatedDate", (Object)this.createdDate()).add("DisplayName", (Object)this.displayName()).add("Owner", (Object)this.owner()).add("VersionName", (Object)this.versionName()).add("PlatformTypes", this.hasPlatformTypes() ? this.platformTypesAsStrings() : null).add("DocumentVersion", (Object)this.documentVersion()).add("DocumentType", (Object)this.documentTypeAsString()).add("SchemaVersion", (Object)this.schemaVersion()).add("DocumentFormat", (Object)this.documentFormatAsString()).add("TargetType", (Object)this.targetType()).add("Tags", this.hasTags() ? this.tags() : null).add("Requires", this.hasRequires() ? this.requires() : null).add("ReviewStatus", (Object)this.reviewStatusAsString()).add("Author", (Object)this.author()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "PlatformTypes": {
                return Optional.ofNullable(clazz.cast(this.platformTypesAsStrings()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Requires": {
                return Optional.ofNullable(clazz.cast(this.requires()));
            }
            case "ReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusAsString()));
            }
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentIdentifier, T> g) {
        return obj -> g.apply((DocumentIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant createdDate;
        private String displayName;
        private String owner;
        private String versionName;
        private List<String> platformTypes = DefaultSdkAutoConstructList.getInstance();
        private String documentVersion;
        private String documentType;
        private String schemaVersion;
        private String documentFormat;
        private String targetType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentRequires> requires = DefaultSdkAutoConstructList.getInstance();
        private String reviewStatus;
        private String author;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            this.name(model.name);
            this.createdDate(model.createdDate);
            this.displayName(model.displayName);
            this.owner(model.owner);
            this.versionName(model.versionName);
            this.platformTypesWithStrings(model.platformTypes);
            this.documentVersion(model.documentVersion);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
            this.documentFormat(model.documentFormat);
            this.targetType(model.targetType);
            this.tags(model.tags);
            this.requires(model.requires);
            this.reviewStatus(model.reviewStatus);
            this.author(model.author);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final Collection<String> getPlatformTypes() {
            if (this.platformTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypesWithStrings(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypesWithStrings(String ... platformTypes) {
            this.platformTypesWithStrings(Arrays.asList(platformTypes));
            return this;
        }

        @Override
        public final Builder platformTypes(Collection<PlatformType> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copyEnumToString(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(PlatformType ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypes(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getDocumentFormat() {
            return this.documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final List<DocumentRequires.Builder> getRequires() {
            List<DocumentRequires.Builder> result = DocumentRequiresListCopier.copyToBuilder(this.requires);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder requires(Collection<DocumentRequires> requires) {
            this.requires = DocumentRequiresListCopier.copy(requires);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(DocumentRequires ... requires) {
            this.requires(Arrays.asList(requires));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(Consumer<DocumentRequires.Builder> ... requires) {
            this.requires(Stream.of(requires).map(c -> (DocumentRequires)((DocumentRequires.Builder)DocumentRequires.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequires(Collection<DocumentRequires.BuilderImpl> requires) {
            this.requires = DocumentRequiresListCopier.copyFromBuilder(requires);
        }

        public final String getReviewStatus() {
            return this.reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentIdentifier> {
        public Builder name(String var1);

        public Builder createdDate(Instant var1);

        public Builder displayName(String var1);

        public Builder owner(String var1);

        public Builder versionName(String var1);

        public Builder platformTypesWithStrings(Collection<String> var1);

        public Builder platformTypesWithStrings(String ... var1);

        public Builder platformTypes(Collection<PlatformType> var1);

        public Builder platformTypes(PlatformType ... var1);

        public Builder documentVersion(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder targetType(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder requires(Collection<DocumentRequires> var1);

        public Builder requires(DocumentRequires ... var1);

        public Builder requires(Consumer<DocumentRequires.Builder> ... var1);

        public Builder reviewStatus(String var1);

        public Builder reviewStatus(ReviewStatus var1);

        public Builder author(String var1);
    }
}

