/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public class GetParametersByPathIterable
implements SdkIterable<GetParametersByPathResponse> {
    private final SsmClient client;
    private final GetParametersByPathRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetParametersByPathIterable(SsmClient client, GetParametersByPathRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public Iterator<GetParametersByPathResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetParametersByPathResponseFetcher
    implements SyncPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetParametersByPathResponse nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathIterable.this.client.getParametersByPath(GetParametersByPathIterable.this.firstRequest);
            }
            return GetParametersByPathIterable.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

