/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntity;

public class GetInventoryPublisher
implements SdkPublisher<GetInventoryResponse> {
    private final SsmAsyncClient client;
    private final GetInventoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInventoryPublisher(SsmAsyncClient client, GetInventoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInventoryPublisher(SsmAsyncClient client, GetInventoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInventoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInventoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InventoryResultEntity> entities() {
        Function<GetInventoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetInventoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetInventoryResponseFetcher
    implements AsyncPageFetcher<GetInventoryResponse> {
        private GetInventoryResponseFetcher() {
        }

        public boolean hasNextPage(GetInventoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInventoryResponse> nextPage(GetInventoryResponse previousPage) {
            if (previousPage == null) {
                return GetInventoryPublisher.this.client.getInventory(GetInventoryPublisher.this.firstRequest);
            }
            return GetInventoryPublisher.this.client.getInventory((GetInventoryRequest)((Object)GetInventoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

