/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AttachmentContent;
import software.amazon.awssdk.services.ssm.model.AttachmentContentListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.DocumentRequires;
import software.amazon.awssdk.services.ssm.model.DocumentRequiresListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentStatus;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.ReviewStatus;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetDocumentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDocumentResponse.getter(GetDocumentResponse::name)).setter(GetDocumentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(GetDocumentResponse.getter(GetDocumentResponse::versionName)).setter(GetDocumentResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(GetDocumentResponse.getter(GetDocumentResponse::documentVersion)).setter(GetDocumentResponse.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetDocumentResponse.getter(GetDocumentResponse::statusAsString)).setter(GetDocumentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusInformation").getter(GetDocumentResponse.getter(GetDocumentResponse::statusInformation)).setter(GetDocumentResponse.setter(Builder::statusInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInformation").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(GetDocumentResponse.getter(GetDocumentResponse::content)).setter(GetDocumentResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentType").getter(GetDocumentResponse.getter(GetDocumentResponse::documentTypeAsString)).setter(GetDocumentResponse.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentFormat").getter(GetDocumentResponse.getter(GetDocumentResponse::documentFormatAsString)).setter(GetDocumentResponse.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final SdkField<List<DocumentRequires>> REQUIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Requires").getter(GetDocumentResponse.getter(GetDocumentResponse::requires)).setter(GetDocumentResponse.setter(Builder::requires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requires").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentRequires::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentContent>> ATTACHMENTS_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentsContent").getter(GetDocumentResponse.getter(GetDocumentResponse::attachmentsContent)).setter(GetDocumentResponse.setter(Builder::attachmentsContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentsContent").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewStatus").getter(GetDocumentResponse.getter(GetDocumentResponse::reviewStatusAsString)).setter(GetDocumentResponse.setter(Builder::reviewStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_NAME_FIELD, DOCUMENT_VERSION_FIELD, STATUS_FIELD, STATUS_INFORMATION_FIELD, CONTENT_FIELD, DOCUMENT_TYPE_FIELD, DOCUMENT_FORMAT_FIELD, REQUIRES_FIELD, ATTACHMENTS_CONTENT_FIELD, REVIEW_STATUS_FIELD));
    private final String name;
    private final String versionName;
    private final String documentVersion;
    private final String status;
    private final String statusInformation;
    private final String content;
    private final String documentType;
    private final String documentFormat;
    private final List<DocumentRequires> requires;
    private final List<AttachmentContent> attachmentsContent;
    private final String reviewStatus;

    private GetDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.documentVersion = builder.documentVersion;
        this.status = builder.status;
        this.statusInformation = builder.statusInformation;
        this.content = builder.content;
        this.documentType = builder.documentType;
        this.documentFormat = builder.documentFormat;
        this.requires = builder.requires;
        this.attachmentsContent = builder.attachmentsContent;
        this.reviewStatus = builder.reviewStatus;
    }

    public final String name() {
        return this.name;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final DocumentStatus status() {
        return DocumentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusInformation() {
        return this.statusInformation;
    }

    public final String content() {
        return this.content;
    }

    public final DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public final String documentTypeAsString() {
        return this.documentType;
    }

    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public final String documentFormatAsString() {
        return this.documentFormat;
    }

    public final boolean hasRequires() {
        return this.requires != null && !(this.requires instanceof SdkAutoConstructList);
    }

    public final List<DocumentRequires> requires() {
        return this.requires;
    }

    public final boolean hasAttachmentsContent() {
        return this.attachmentsContent != null && !(this.attachmentsContent instanceof SdkAutoConstructList);
    }

    public final List<AttachmentContent> attachmentsContent() {
        return this.attachmentsContent;
    }

    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(this.reviewStatus);
    }

    public final String reviewStatusAsString() {
        return this.reviewStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequires() ? this.requires() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentsContent() ? this.attachmentsContent() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResponse)) {
            return false;
        }
        GetDocumentResponse other = (GetDocumentResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusInformation(), other.statusInformation()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString()) && this.hasRequires() == other.hasRequires() && Objects.equals(this.requires(), other.requires()) && this.hasAttachmentsContent() == other.hasAttachmentsContent() && Objects.equals(this.attachmentsContent(), other.attachmentsContent()) && Objects.equals(this.reviewStatusAsString(), other.reviewStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDocumentResponse").add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("DocumentVersion", (Object)this.documentVersion()).add("Status", (Object)this.statusAsString()).add("StatusInformation", (Object)this.statusInformation()).add("Content", (Object)this.content()).add("DocumentType", (Object)this.documentTypeAsString()).add("DocumentFormat", (Object)this.documentFormatAsString()).add("Requires", this.hasRequires() ? this.requires() : null).add("AttachmentsContent", this.hasAttachmentsContent() ? this.attachmentsContent() : null).add("ReviewStatus", (Object)this.reviewStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusInformation": {
                return Optional.ofNullable(clazz.cast(this.statusInformation()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
            case "Requires": {
                return Optional.ofNullable(clazz.cast(this.requires()));
            }
            case "AttachmentsContent": {
                return Optional.ofNullable(clazz.cast(this.attachmentsContent()));
            }
            case "ReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.reviewStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentResponse, T> g) {
        return obj -> g.apply((GetDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String name;
        private String versionName;
        private String documentVersion;
        private String status;
        private String statusInformation;
        private String content;
        private String documentType;
        private String documentFormat;
        private List<DocumentRequires> requires = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentContent> attachmentsContent = DefaultSdkAutoConstructList.getInstance();
        private String reviewStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentResponse model) {
            super(model);
            this.name(model.name);
            this.versionName(model.versionName);
            this.documentVersion(model.documentVersion);
            this.status(model.status);
            this.statusInformation(model.statusInformation);
            this.content(model.content);
            this.documentType(model.documentType);
            this.documentFormat(model.documentFormat);
            this.requires(model.requires);
            this.attachmentsContent(model.attachmentsContent);
            this.reviewStatus(model.reviewStatus);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusInformation() {
            return this.statusInformation;
        }

        @Override
        public final Builder statusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
            return this;
        }

        public final void setStatusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getDocumentFormat() {
            return this.documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final Collection<DocumentRequires.Builder> getRequires() {
            if (this.requires instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requires != null ? (Collection)this.requires.stream().map(DocumentRequires::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requires(Collection<DocumentRequires> requires) {
            this.requires = DocumentRequiresListCopier.copy(requires);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(DocumentRequires ... requires) {
            this.requires(Arrays.asList(requires));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(Consumer<DocumentRequires.Builder> ... requires) {
            this.requires(Stream.of(requires).map(c -> (DocumentRequires)((DocumentRequires.Builder)DocumentRequires.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRequires(Collection<DocumentRequires.BuilderImpl> requires) {
            this.requires = DocumentRequiresListCopier.copyFromBuilder(requires);
        }

        public final Collection<AttachmentContent.Builder> getAttachmentsContent() {
            if (this.attachmentsContent instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachmentsContent != null ? (Collection)this.attachmentsContent.stream().map(AttachmentContent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentsContent(Collection<AttachmentContent> attachmentsContent) {
            this.attachmentsContent = AttachmentContentListCopier.copy(attachmentsContent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsContent(AttachmentContent ... attachmentsContent) {
            this.attachmentsContent(Arrays.asList(attachmentsContent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsContent(Consumer<AttachmentContent.Builder> ... attachmentsContent) {
            this.attachmentsContent(Stream.of(attachmentsContent).map(c -> (AttachmentContent)((AttachmentContent.Builder)AttachmentContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentsContent(Collection<AttachmentContent.BuilderImpl> attachmentsContent) {
            this.attachmentsContent = AttachmentContentListCopier.copyFromBuilder(attachmentsContent);
        }

        public final String getReviewStatus() {
            return this.reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public GetDocumentResponse build() {
            return new GetDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDocumentResponse> {
        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder documentVersion(String var1);

        public Builder status(String var1);

        public Builder status(DocumentStatus var1);

        public Builder statusInformation(String var1);

        public Builder content(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder requires(Collection<DocumentRequires> var1);

        public Builder requires(DocumentRequires ... var1);

        public Builder requires(Consumer<DocumentRequires.Builder> ... var1);

        public Builder attachmentsContent(Collection<AttachmentContent> var1);

        public Builder attachmentsContent(AttachmentContent ... var1);

        public Builder attachmentsContent(Consumer<AttachmentContent.Builder> ... var1);

        public Builder reviewStatus(String var1);

        public Builder reviewStatus(ReviewStatus var1);
    }
}

