/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.CommandInvocationListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommandInvocationsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListCommandInvocationsResponse> {
    private static final SdkField<List<CommandInvocation>> COMMAND_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommandInvocations").getter(ListCommandInvocationsResponse.getter(ListCommandInvocationsResponse::commandInvocations)).setter(ListCommandInvocationsResponse.setter(Builder::commandInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandInvocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommandInvocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCommandInvocationsResponse.getter(ListCommandInvocationsResponse::nextToken)).setter(ListCommandInvocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_INVOCATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CommandInvocation> commandInvocations;
    private final String nextToken;

    private ListCommandInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.commandInvocations = builder.commandInvocations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCommandInvocations() {
        return this.commandInvocations != null && !(this.commandInvocations instanceof SdkAutoConstructList);
    }

    public final List<CommandInvocation> commandInvocations() {
        return this.commandInvocations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandInvocations() ? this.commandInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsResponse)) {
            return false;
        }
        ListCommandInvocationsResponse other = (ListCommandInvocationsResponse)((Object)obj);
        return this.hasCommandInvocations() == other.hasCommandInvocations() && Objects.equals(this.commandInvocations(), other.commandInvocations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommandInvocationsResponse").add("CommandInvocations", this.hasCommandInvocations() ? this.commandInvocations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandInvocations": {
                return Optional.ofNullable(clazz.cast(this.commandInvocations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCommandInvocationsResponse, T> g) {
        return obj -> g.apply((ListCommandInvocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<CommandInvocation> commandInvocations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsResponse model) {
            super(model);
            this.commandInvocations(model.commandInvocations);
            this.nextToken(model.nextToken);
        }

        public final Collection<CommandInvocation.Builder> getCommandInvocations() {
            if (this.commandInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commandInvocations != null ? (Collection)this.commandInvocations.stream().map(CommandInvocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandInvocations(Collection<CommandInvocation> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copy(commandInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(CommandInvocation ... commandInvocations) {
            this.commandInvocations(Arrays.asList(commandInvocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(Consumer<CommandInvocation.Builder> ... commandInvocations) {
            this.commandInvocations(Stream.of(commandInvocations).map(c -> (CommandInvocation)((CommandInvocation.Builder)CommandInvocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommandInvocations(Collection<CommandInvocation.BuilderImpl> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copyFromBuilder(commandInvocations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandInvocationsResponse build() {
            return new ListCommandInvocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommandInvocationsResponse> {
        public Builder commandInvocations(Collection<CommandInvocation> var1);

        public Builder commandInvocations(CommandInvocation ... var1);

        public Builder commandInvocations(Consumer<CommandInvocation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

