/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemEventSummary;

public class ListOpsItemEventsPublisher
implements SdkPublisher<ListOpsItemEventsResponse> {
    private final SsmAsyncClient client;
    private final ListOpsItemEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOpsItemEventsPublisher(SsmAsyncClient client, ListOpsItemEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOpsItemEventsPublisher(SsmAsyncClient client, ListOpsItemEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOpsItemEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOpsItemEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpsItemEventSummary> summaries() {
        Function<ListOpsItemEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOpsItemEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOpsItemEventsResponseFetcher
    implements AsyncPageFetcher<ListOpsItemEventsResponse> {
        private ListOpsItemEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListOpsItemEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOpsItemEventsResponse> nextPage(ListOpsItemEventsResponse previousPage) {
            if (previousPage == null) {
                return ListOpsItemEventsPublisher.this.client.listOpsItemEvents(ListOpsItemEventsPublisher.this.firstRequest);
            }
            return ListOpsItemEventsPublisher.this.client.listOpsItemEvents((ListOpsItemEventsRequest)((Object)ListOpsItemEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

