/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusAggregatedCountCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceAggregatedAssociationOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(InstanceAggregatedAssociationOverview.getter(InstanceAggregatedAssociationOverview::detailedStatus)).setter(InstanceAggregatedAssociationOverview.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> INSTANCE_ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InstanceAssociationStatusAggregatedCount").getter(InstanceAggregatedAssociationOverview.getter(InstanceAggregatedAssociationOverview::instanceAssociationStatusAggregatedCount)).setter(InstanceAggregatedAssociationOverview.setter(Builder::instanceAssociationStatusAggregatedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAssociationStatusAggregatedCount").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_STATUS_FIELD, INSTANCE_ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detailedStatus;
    private final Map<String, Integer> instanceAssociationStatusAggregatedCount;

    private InstanceAggregatedAssociationOverview(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
        this.instanceAssociationStatusAggregatedCount = builder.instanceAssociationStatusAggregatedCount;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public boolean hasInstanceAssociationStatusAggregatedCount() {
        return this.instanceAssociationStatusAggregatedCount != null && !(this.instanceAssociationStatusAggregatedCount instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> instanceAssociationStatusAggregatedCount() {
        return this.instanceAssociationStatusAggregatedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceAssociationStatusAggregatedCount() ? this.instanceAssociationStatusAggregatedCount() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAggregatedAssociationOverview)) {
            return false;
        }
        InstanceAggregatedAssociationOverview other = (InstanceAggregatedAssociationOverview)obj;
        return Objects.equals(this.detailedStatus(), other.detailedStatus()) && this.hasInstanceAssociationStatusAggregatedCount() == other.hasInstanceAssociationStatusAggregatedCount() && Objects.equals(this.instanceAssociationStatusAggregatedCount(), other.instanceAssociationStatusAggregatedCount());
    }

    public String toString() {
        return ToString.builder((String)"InstanceAggregatedAssociationOverview").add("DetailedStatus", (Object)this.detailedStatus()).add("InstanceAssociationStatusAggregatedCount", this.hasInstanceAssociationStatusAggregatedCount() ? this.instanceAssociationStatusAggregatedCount() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "InstanceAssociationStatusAggregatedCount": {
                return Optional.ofNullable(clazz.cast(this.instanceAssociationStatusAggregatedCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAggregatedAssociationOverview, T> g) {
        return obj -> g.apply((InstanceAggregatedAssociationOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detailedStatus;
        private Map<String, Integer> instanceAssociationStatusAggregatedCount = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAggregatedAssociationOverview model) {
            this.detailedStatus(model.detailedStatus);
            this.instanceAssociationStatusAggregatedCount(model.instanceAssociationStatusAggregatedCount);
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getInstanceAssociationStatusAggregatedCount() {
            if (this.instanceAssociationStatusAggregatedCount instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.instanceAssociationStatusAggregatedCount;
        }

        @Override
        public final Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier.copy(instanceAssociationStatusAggregatedCount);
            return this;
        }

        public final void setInstanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier.copy(instanceAssociationStatusAggregatedCount);
        }

        public InstanceAggregatedAssociationOverview build() {
            return new InstanceAggregatedAssociationOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
        public Builder detailedStatus(String var1);

        public Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> var1);
    }
}

