/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryAggregator;
import software.amazon.awssdk.services.ssm.model.InventoryAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.InventoryFilter;
import software.amazon.awssdk.services.ssm.model.InventoryFilterListCopier;
import software.amazon.awssdk.services.ssm.model.ResultAttribute;
import software.amazon.awssdk.services.ssm.model.ResultAttributeListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInventoryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetInventoryRequest> {
    private static final SdkField<List<InventoryFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetInventoryRequest.getter(GetInventoryRequest::filters)).setter(GetInventoryRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InventoryAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(GetInventoryRequest.getter(GetInventoryRequest::aggregators)).setter(GetInventoryRequest.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResultAttribute>> RESULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultAttributes").getter(GetInventoryRequest.getter(GetInventoryRequest::resultAttributes)).setter(GetInventoryRequest.setter(Builder::resultAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetInventoryRequest.getter(GetInventoryRequest::nextToken)).setter(GetInventoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetInventoryRequest.getter(GetInventoryRequest::maxResults)).setter(GetInventoryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, AGGREGATORS_FIELD, RESULT_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<InventoryFilter> filters;
    private final List<InventoryAggregator> aggregators;
    private final List<ResultAttribute> resultAttributes;
    private final String nextToken;
    private final Integer maxResults;

    private GetInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<InventoryFilter> filters() {
        return this.filters;
    }

    public boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public List<InventoryAggregator> aggregators() {
        return this.aggregators;
    }

    public boolean hasResultAttributes() {
        return this.resultAttributes != null && !(this.resultAttributes instanceof SdkAutoConstructList);
    }

    public List<ResultAttribute> resultAttributes() {
        return this.resultAttributes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultAttributes() ? this.resultAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest)((Object)obj);
        return this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators()) && this.hasResultAttributes() == other.hasResultAttributes() && Objects.equals(this.resultAttributes(), other.resultAttributes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetInventoryRequest").add("Filters", this.hasFilters() ? this.filters() : null).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).add("ResultAttributes", this.hasResultAttributes() ? this.resultAttributes() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
            case "ResultAttributes": {
                return Optional.ofNullable(clazz.cast(this.resultAttributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInventoryRequest, T> g) {
        return obj -> g.apply((GetInventoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<InventoryFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<InventoryAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();
        private List<ResultAttribute> resultAttributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryRequest model) {
            super(model);
            this.filters(model.filters);
            this.aggregators(model.aggregators);
            this.resultAttributes(model.resultAttributes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<InventoryFilter.Builder> getFilters() {
            if (this.filters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filters != null ? (Collection)this.filters.stream().map(InventoryFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InventoryFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (InventoryFilter)((InventoryFilter.Builder)InventoryFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<InventoryAggregator.Builder> getAggregators() {
            if (this.aggregators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregators != null ? (Collection)this.aggregators.stream().map(InventoryAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<InventoryAggregator.Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (InventoryAggregator)((InventoryAggregator.Builder)InventoryAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAggregators(Collection<InventoryAggregator.BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        public final Collection<ResultAttribute.Builder> getResultAttributes() {
            if (this.resultAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultAttributes != null ? (Collection)this.resultAttributes.stream().map(ResultAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(ResultAttribute ... resultAttributes) {
            this.resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(Consumer<ResultAttribute.Builder> ... resultAttributes) {
            this.resultAttributes(Stream.of(resultAttributes).map(c -> (ResultAttribute)((ResultAttribute.Builder)ResultAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResultAttributes(Collection<ResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInventoryRequest build() {
            return new GetInventoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInventoryRequest> {
        public Builder filters(Collection<InventoryFilter> var1);

        public Builder filters(InventoryFilter ... var1);

        public Builder filters(Consumer<InventoryFilter.Builder> ... var1);

        public Builder aggregators(Collection<InventoryAggregator> var1);

        public Builder aggregators(InventoryAggregator ... var1);

        public Builder aggregators(Consumer<InventoryAggregator.Builder> ... var1);

        public Builder resultAttributes(Collection<ResultAttribute> var1);

        public Builder resultAttributes(ResultAttribute ... var1);

        public Builder resultAttributes(Consumer<ResultAttribute.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

