/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSetting> {
    private static final SdkField<String> SETTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SettingId").getter(ServiceSetting.getter(ServiceSetting::settingId)).setter(ServiceSetting.setter(Builder::settingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingId").build()}).build();
    private static final SdkField<String> SETTING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SettingValue").getter(ServiceSetting.getter(ServiceSetting::settingValue)).setter(ServiceSetting.setter(Builder::settingValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingValue").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(ServiceSetting.getter(ServiceSetting::lastModifiedDate)).setter(ServiceSetting.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedUser").getter(ServiceSetting.getter(ServiceSetting::lastModifiedUser)).setter(ServiceSetting.setter(Builder::lastModifiedUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedUser").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ServiceSetting.getter(ServiceSetting::arn)).setter(ServiceSetting.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ServiceSetting.getter(ServiceSetting::status)).setter(ServiceSetting.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_ID_FIELD, SETTING_VALUE_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_USER_FIELD, ARN_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String settingId;
    private final String settingValue;
    private final Instant lastModifiedDate;
    private final String lastModifiedUser;
    private final String arn;
    private final String status;

    private ServiceSetting(BuilderImpl builder) {
        this.settingId = builder.settingId;
        this.settingValue = builder.settingValue;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.arn = builder.arn;
        this.status = builder.status;
    }

    public String settingId() {
        return this.settingId;
    }

    public String settingValue() {
        return this.settingValue;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String arn() {
        return this.arn;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.settingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSetting)) {
            return false;
        }
        ServiceSetting other = (ServiceSetting)obj;
        return Objects.equals(this.settingId(), other.settingId()) && Objects.equals(this.settingValue(), other.settingValue()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ServiceSetting").add("SettingId", (Object)this.settingId()).add("SettingValue", (Object)this.settingValue()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SettingId": {
                return Optional.ofNullable(clazz.cast(this.settingId()));
            }
            case "SettingValue": {
                return Optional.ofNullable(clazz.cast(this.settingValue()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedUser": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedUser()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSetting, T> g) {
        return obj -> g.apply((ServiceSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String settingId;
        private String settingValue;
        private Instant lastModifiedDate;
        private String lastModifiedUser;
        private String arn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSetting model) {
            this.settingId(model.settingId);
            this.settingValue(model.settingValue);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.arn(model.arn);
            this.status(model.status);
        }

        public final String getSettingId() {
            return this.settingId;
        }

        @Override
        public final Builder settingId(String settingId) {
            this.settingId = settingId;
            return this;
        }

        public final void setSettingId(String settingId) {
            this.settingId = settingId;
        }

        public final String getSettingValue() {
            return this.settingValue;
        }

        @Override
        public final Builder settingValue(String settingValue) {
            this.settingValue = settingValue;
            return this;
        }

        public final void setSettingValue(String settingValue) {
            this.settingValue = settingValue;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ServiceSetting build() {
            return new ServiceSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSetting> {
        public Builder settingId(String var1);

        public Builder settingValue(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);
    }
}

