/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationFilter;
import software.amazon.awssdk.services.ssm.model.AssociationFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociationsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, ListAssociationsRequest> {
    private static final SdkField<List<AssociationFilter>> ASSOCIATION_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociationFilterList").getter(ListAssociationsRequest.getter(ListAssociationsRequest::associationFilterList)).setter(ListAssociationsRequest.setter(Builder::associationFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAssociationsRequest.getter(ListAssociationsRequest::maxResults)).setter(ListAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssociationsRequest.getter(ListAssociationsRequest::nextToken)).setter(ListAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FILTER_LIST_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AssociationFilter> associationFilterList;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.associationFilterList = builder.associationFilterList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAssociationFilterList() {
        return this.associationFilterList != null && !(this.associationFilterList instanceof SdkAutoConstructList);
    }

    public List<AssociationFilter> associationFilterList() {
        return this.associationFilterList;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationFilterList() ? this.associationFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)((Object)obj);
        return this.hasAssociationFilterList() == other.hasAssociationFilterList() && Objects.equals(this.associationFilterList(), other.associationFilterList()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAssociationsRequest").add("AssociationFilterList", this.hasAssociationFilterList() ? this.associationFilterList() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationFilterList": {
                return Optional.ofNullable(clazz.cast(this.associationFilterList()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociationsRequest, T> g) {
        return obj -> g.apply((ListAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<AssociationFilter> associationFilterList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociationsRequest model) {
            super(model);
            this.associationFilterList(model.associationFilterList);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<AssociationFilter.Builder> getAssociationFilterList() {
            if (this.associationFilterList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associationFilterList != null ? (Collection)this.associationFilterList.stream().map(AssociationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associationFilterList(Collection<AssociationFilter> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copy(associationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationFilterList(AssociationFilter ... associationFilterList) {
            this.associationFilterList(Arrays.asList(associationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationFilterList(Consumer<AssociationFilter.Builder> ... associationFilterList) {
            this.associationFilterList(Stream.of(associationFilterList).map(c -> (AssociationFilter)((AssociationFilter.Builder)AssociationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociationFilterList(Collection<AssociationFilter.BuilderImpl> associationFilterList) {
            this.associationFilterList = AssociationFilterListCopier.copyFromBuilder(associationFilterList);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociationsRequest build() {
            return new ListAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociationsRequest> {
        public Builder associationFilterList(Collection<AssociationFilter> var1);

        public Builder associationFilterList(AssociationFilter ... var1);

        public Builder associationFilterList(Consumer<AssociationFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

