/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsItemDataValue;
import software.amazon.awssdk.services.ssm.model.OpsItemNotification;
import software.amazon.awssdk.services.ssm.model.OpsItemNotificationsCopier;
import software.amazon.awssdk.services.ssm.model.OpsItemOperationalDataCopier;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItem;
import software.amazon.awssdk.services.ssm.model.RelatedOpsItemsCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOpsItemRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateOpsItemRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::description)).setter(CreateOpsItemRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, OpsItemDataValue>> OPERATIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OperationalData").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::operationalData)).setter(CreateOpsItemRequest.setter(Builder::operationalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationalData").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemDataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OpsItemNotification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notifications").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::notifications)).setter(CreateOpsItemRequest.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::priority)).setter(CreateOpsItemRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<List<RelatedOpsItem>> RELATED_OPS_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedOpsItems").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::relatedOpsItems)).setter(CreateOpsItemRequest.setter(Builder::relatedOpsItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedOpsItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedOpsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::source)).setter(CreateOpsItemRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::title)).setter(CreateOpsItemRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::tags)).setter(CreateOpsItemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::category)).setter(CreateOpsItemRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(CreateOpsItemRequest.getter(CreateOpsItemRequest::severity)).setter(CreateOpsItemRequest.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, OPERATIONAL_DATA_FIELD, NOTIFICATIONS_FIELD, PRIORITY_FIELD, RELATED_OPS_ITEMS_FIELD, SOURCE_FIELD, TITLE_FIELD, TAGS_FIELD, CATEGORY_FIELD, SEVERITY_FIELD));
    private final String description;
    private final Map<String, OpsItemDataValue> operationalData;
    private final List<OpsItemNotification> notifications;
    private final Integer priority;
    private final List<RelatedOpsItem> relatedOpsItems;
    private final String source;
    private final String title;
    private final List<Tag> tags;
    private final String category;
    private final String severity;

    private CreateOpsItemRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.operationalData = builder.operationalData;
        this.notifications = builder.notifications;
        this.priority = builder.priority;
        this.relatedOpsItems = builder.relatedOpsItems;
        this.source = builder.source;
        this.title = builder.title;
        this.tags = builder.tags;
        this.category = builder.category;
        this.severity = builder.severity;
    }

    public String description() {
        return this.description;
    }

    public boolean hasOperationalData() {
        return this.operationalData != null && !(this.operationalData instanceof SdkAutoConstructMap);
    }

    public Map<String, OpsItemDataValue> operationalData() {
        return this.operationalData;
    }

    public boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public List<OpsItemNotification> notifications() {
        return this.notifications;
    }

    public Integer priority() {
        return this.priority;
    }

    public boolean hasRelatedOpsItems() {
        return this.relatedOpsItems != null && !(this.relatedOpsItems instanceof SdkAutoConstructList);
    }

    public List<RelatedOpsItem> relatedOpsItems() {
        return this.relatedOpsItems;
    }

    public String source() {
        return this.source;
    }

    public String title() {
        return this.title;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String category() {
        return this.category;
    }

    public String severity() {
        return this.severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationalData() ? this.operationalData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedOpsItems() ? this.relatedOpsItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpsItemRequest)) {
            return false;
        }
        CreateOpsItemRequest other = (CreateOpsItemRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasOperationalData() == other.hasOperationalData() && Objects.equals(this.operationalData(), other.operationalData()) && this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.priority(), other.priority()) && this.hasRelatedOpsItems() == other.hasRelatedOpsItems() && Objects.equals(this.relatedOpsItems(), other.relatedOpsItems()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.title(), other.title()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.severity(), other.severity());
    }

    public String toString() {
        return ToString.builder((String)"CreateOpsItemRequest").add("Description", (Object)this.description()).add("OperationalData", this.hasOperationalData() ? this.operationalData() : null).add("Notifications", this.hasNotifications() ? this.notifications() : null).add("Priority", (Object)this.priority()).add("RelatedOpsItems", this.hasRelatedOpsItems() ? this.relatedOpsItems() : null).add("Source", (Object)this.source()).add("Title", (Object)this.title()).add("Tags", this.hasTags() ? this.tags() : null).add("Category", (Object)this.category()).add("Severity", (Object)this.severity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperationalData": {
                return Optional.ofNullable(clazz.cast(this.operationalData()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RelatedOpsItems": {
                return Optional.ofNullable(clazz.cast(this.relatedOpsItems()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpsItemRequest, T> g) {
        return obj -> g.apply((CreateOpsItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String description;
        private Map<String, OpsItemDataValue> operationalData = DefaultSdkAutoConstructMap.getInstance();
        private List<OpsItemNotification> notifications = DefaultSdkAutoConstructList.getInstance();
        private Integer priority;
        private List<RelatedOpsItem> relatedOpsItems = DefaultSdkAutoConstructList.getInstance();
        private String source;
        private String title;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String category;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpsItemRequest model) {
            super(model);
            this.description(model.description);
            this.operationalData(model.operationalData);
            this.notifications(model.notifications);
            this.priority(model.priority);
            this.relatedOpsItems(model.relatedOpsItems);
            this.source(model.source);
            this.title(model.title);
            this.tags(model.tags);
            this.category(model.category);
            this.severity(model.severity);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, OpsItemDataValue.Builder> getOperationalData() {
            if (this.operationalData instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.operationalData != null ? CollectionUtils.mapValues(this.operationalData, OpsItemDataValue::toBuilder) : null;
        }

        @Override
        public final Builder operationalData(Map<String, OpsItemDataValue> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copy(operationalData);
            return this;
        }

        public final void setOperationalData(Map<String, OpsItemDataValue.BuilderImpl> operationalData) {
            this.operationalData = OpsItemOperationalDataCopier.copyFromBuilder(operationalData);
        }

        public final Collection<OpsItemNotification.Builder> getNotifications() {
            if (this.notifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notifications != null ? (Collection)this.notifications.stream().map(OpsItemNotification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notifications(Collection<OpsItemNotification> notifications) {
            this.notifications = OpsItemNotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(OpsItemNotification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<OpsItemNotification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (OpsItemNotification)((OpsItemNotification.Builder)OpsItemNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotifications(Collection<OpsItemNotification.BuilderImpl> notifications) {
            this.notifications = OpsItemNotificationsCopier.copyFromBuilder(notifications);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<RelatedOpsItem.Builder> getRelatedOpsItems() {
            if (this.relatedOpsItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedOpsItems != null ? (Collection)this.relatedOpsItems.stream().map(RelatedOpsItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copy(relatedOpsItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
            this.relatedOpsItems(Arrays.asList(relatedOpsItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... relatedOpsItems) {
            this.relatedOpsItems(Stream.of(relatedOpsItems).map(c -> (RelatedOpsItem)((RelatedOpsItem.Builder)RelatedOpsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedOpsItems(Collection<RelatedOpsItem.BuilderImpl> relatedOpsItems) {
            this.relatedOpsItems = RelatedOpsItemsCopier.copyFromBuilder(relatedOpsItems);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOpsItemRequest build() {
            return new CreateOpsItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOpsItemRequest> {
        public Builder description(String var1);

        public Builder operationalData(Map<String, OpsItemDataValue> var1);

        public Builder notifications(Collection<OpsItemNotification> var1);

        public Builder notifications(OpsItemNotification ... var1);

        public Builder notifications(Consumer<OpsItemNotification.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder relatedOpsItems(Collection<RelatedOpsItem> var1);

        public Builder relatedOpsItems(RelatedOpsItem ... var1);

        public Builder relatedOpsItems(Consumer<RelatedOpsItem.Builder> ... var1);

        public Builder source(String var1);

        public Builder title(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder category(String var1);

        public Builder severity(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

