/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.CalendarNameOrARNListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCalendarStateRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, GetCalendarStateRequest> {
    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalendarNames").getter(GetCalendarStateRequest.getter(GetCalendarStateRequest::calendarNames)).setter(GetCalendarStateRequest.setter(Builder::calendarNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AtTime").getter(GetCalendarStateRequest.getter(GetCalendarStateRequest::atTime)).setter(GetCalendarStateRequest.setter(Builder::atTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALENDAR_NAMES_FIELD, AT_TIME_FIELD));
    private final List<String> calendarNames;
    private final String atTime;

    private GetCalendarStateRequest(BuilderImpl builder) {
        super(builder);
        this.calendarNames = builder.calendarNames;
        this.atTime = builder.atTime;
    }

    public boolean hasCalendarNames() {
        return this.calendarNames != null && !(this.calendarNames instanceof SdkAutoConstructList);
    }

    public List<String> calendarNames() {
        return this.calendarNames;
    }

    public String atTime() {
        return this.atTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.calendarNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.atTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalendarStateRequest)) {
            return false;
        }
        GetCalendarStateRequest other = (GetCalendarStateRequest)((Object)obj);
        return Objects.equals(this.calendarNames(), other.calendarNames()) && Objects.equals(this.atTime(), other.atTime());
    }

    public String toString() {
        return ToString.builder((String)"GetCalendarStateRequest").add("CalendarNames", this.calendarNames()).add("AtTime", (Object)this.atTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalendarNames": {
                return Optional.ofNullable(clazz.cast(this.calendarNames()));
            }
            case "AtTime": {
                return Optional.ofNullable(clazz.cast(this.atTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCalendarStateRequest, T> g) {
        return obj -> g.apply((GetCalendarStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();
        private String atTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalendarStateRequest model) {
            super(model);
            this.calendarNames(model.calendarNames);
            this.atTime(model.atTime);
        }

        public final Collection<String> getCalendarNames() {
            return this.calendarNames;
        }

        @Override
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calendarNames(String ... calendarNames) {
            this.calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        public final String getAtTime() {
            return this.atTime;
        }

        @Override
        public final Builder atTime(String atTime) {
            this.atTime = atTime;
            return this;
        }

        public final void setAtTime(String atTime) {
            this.atTime = atTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCalendarStateRequest build() {
            return new GetCalendarStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCalendarStateRequest> {
        public Builder calendarNames(Collection<String> var1);

        public Builder calendarNames(String ... var1);

        public Builder atTime(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

