/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceItemDetailsCopier;
import software.amazon.awssdk.services.ssm.model.ComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.ComplianceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComplianceItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComplianceItem> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::complianceType)).setter(ComplianceItem.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::resourceType)).setter(ComplianceItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::resourceId)).setter(ComplianceItem.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::id)).setter(ComplianceItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::title)).setter(ComplianceItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::statusAsString)).setter(ComplianceItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ComplianceItem.getter(ComplianceItem::severityAsString)).setter(ComplianceItem.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<ComplianceExecutionSummary> EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ComplianceItem.getter(ComplianceItem::executionSummary)).setter(ComplianceItem.setter(Builder::executionSummary)).constructor(ComplianceExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()}).build();
    private static final SdkField<Map<String, String>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ComplianceItem.getter(ComplianceItem::details)).setter(ComplianceItem.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, ID_FIELD, TITLE_FIELD, STATUS_FIELD, SEVERITY_FIELD, EXECUTION_SUMMARY_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final String resourceType;
    private final String resourceId;
    private final String id;
    private final String title;
    private final String status;
    private final String severity;
    private final ComplianceExecutionSummary executionSummary;
    private final Map<String, String> details;

    private ComplianceItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.id = builder.id;
        this.title = builder.title;
        this.status = builder.status;
        this.severity = builder.severity;
        this.executionSummary = builder.executionSummary;
        this.details = builder.details;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ComplianceSeverity severity() {
        return ComplianceSeverity.fromValue(this.severity);
    }

    public String severityAsString() {
        return this.severity;
    }

    public ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructMap);
    }

    public Map<String, String> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceItem)) {
            return false;
        }
        ComplianceItem other = (ComplianceItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"ComplianceItem").add("ComplianceType", (Object)this.complianceType()).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Status", (Object)this.statusAsString()).add("Severity", (Object)this.severityAsString()).add("ExecutionSummary", (Object)this.executionSummary()).add("Details", this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceType()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "ExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.executionSummary()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceItem, T> g) {
        return obj -> g.apply((ComplianceItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private String resourceType;
        private String resourceId;
        private String id;
        private String title;
        private String status;
        private String severity;
        private ComplianceExecutionSummary executionSummary;
        private Map<String, String> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceItem model) {
            this.complianceType(model.complianceType);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.id(model.id);
            this.title(model.title);
            this.status(model.status);
            this.severity(model.severity);
            this.executionSummary(model.executionSummary);
            this.details(model.details);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ComplianceSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        public final Map<String, String> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, String> details) {
            this.details = ComplianceItemDetailsCopier.copy(details);
        }

        public ComplianceItem build() {
            return new ComplianceItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComplianceItem> {
        public Builder complianceType(String var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder id(String var1);

        public Builder title(String var1);

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder severity(String var1);

        public Builder severity(ComplianceSeverity var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().applyMutation(executionSummary)).build());
        }

        public Builder details(Map<String, String> var1);
    }
}

